/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.component.IActivateDeactivate;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorInternalException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class FunctorTools {
    public static Object asResult(Object object) throws FunctorException {
        try {
            FunctorTools.prepare(object);
            if (object instanceof Future) {
                Future future = (Future)object;
                if (future.isDone()) {
                    return future.get();
                }
                return future;
            }
            return object;
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, FunctorException.class);
        }
    }

    protected static Object computeFromCallable(Callable callable) throws FunctorException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, FunctorException.class);
        }
    }

    protected static Object computeFromFunctor(IFunctor functor, IFunctorCall call) throws FunctorException {
        try {
            return functor.perform(call);
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, FunctorException.class);
        }
    }

    protected static Object computeFromRunnable(Runnable runnable) throws FunctorException {
        try {
            runnable.run();
            return null;
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, FunctorException.class);
        }
    }

    public static Future launch(InstanceSpec<?> functorDef, IArgs args) throws ObjectCreationException {
        Object instance;
        try {
            instance = functorDef.createInstance();
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, ObjectCreationException.class);
        }
        if (instance instanceof IFunctor) {
            IFunctor functor = (IFunctor)instance;
            return Promise.wrap(() -> FunctorTools.computeFromFunctor(functor, new FunctorCall(null, args)));
        }
        FunctorTools.prepare(instance);
        if (instance instanceof Future) {
            return (Future)instance;
        }
        return Promise.newFinished(instance);
    }

    public static Future launch(Object functorDef, IArgs args) throws ObjectCreationException {
        if (functorDef == null) {
            return null;
        }
        if (functorDef instanceof IFunctor) {
            IFunctor functor = (IFunctor)functorDef;
            return Promise.wrap(() -> FunctorTools.computeFromFunctor(functor, new FunctorCall(null, args)));
        }
        if (functorDef instanceof Callable) {
            Callable callable = (Callable)functorDef;
            return Promise.wrap(() -> FunctorTools.computeFromCallable(callable));
        }
        if (functorDef instanceof Runnable) {
            Runnable runnable = (Runnable)functorDef;
            return Promise.wrap(() -> FunctorTools.computeFromRunnable(runnable));
        }
        if (functorDef instanceof InstanceSpec) {
            InstanceSpec spec = (InstanceSpec)functorDef;
            return FunctorTools.launch(spec, args);
        }
        InstanceSpec<Object> spec = InstanceSpec.createFromFactory(Object.class, functorDef, args);
        return FunctorTools.launch(spec, args);
    }

    public static Object perform(InstanceSpec<?> functorDef) throws FunctorException {
        return FunctorTools.perform(functorDef, (IFunctorCall)new FunctorCall(null, Args.create()));
    }

    public static Object perform(InstanceSpec<?> functorDef, IFunctorCall call) throws FunctorException {
        Object instance = null;
        try {
            instance = functorDef.createInstance();
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, FunctorInternalException.class);
        }
        if (instance instanceof IFunctor) {
            IFunctor functor = instance;
            return FunctorTools.computeFromFunctor(functor, call);
        }
        return FunctorTools.asResult(instance);
    }

    public static Object perform(Object functorDef, IArgs args) throws FunctorException {
        return FunctorTools.perform(functorDef, (IFunctorCall)new FunctorCall(null, args));
    }

    public static Object perform(Object functorDef, IFunctorCall call) throws FunctorException {
        if (functorDef == null) {
            return null;
        }
        if (functorDef instanceof IFunctor) {
            IFunctor functor = (IFunctor)functorDef;
            return FunctorTools.computeFromFunctor(functor, call);
        }
        if (functorDef instanceof Callable) {
            Callable callable = (Callable)functorDef;
            return FunctorTools.computeFromCallable(callable);
        }
        if (functorDef instanceof Runnable) {
            Runnable runnable = (Runnable)functorDef;
            return FunctorTools.computeFromRunnable(runnable);
        }
        if (functorDef instanceof InstanceSpec) {
            InstanceSpec spec = (InstanceSpec)functorDef;
            return FunctorTools.perform(spec, call);
        }
        InstanceSpec<Object> spec = InstanceSpec.createFromFactory(Object.class, functorDef, call.getArgs());
        return FunctorTools.perform(spec, call);
    }

    protected static void prepare(Object object) throws ObjectCreationException {
        try {
            if (object instanceof IStartStop) {
                IStartStop ss = (IStartStop)object;
                ss.start();
                if (ss.isStarted() && object instanceof IActivateDeactivate) {
                    IActivateDeactivate ad = (IActivateDeactivate)object;
                    ad.activate();
                }
            }
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, ObjectCreationException.class);
        }
    }

    private FunctorTools() {
    }

    static class FutureFunctor
    implements IFunctor {
        private final IFunctor functor;

        public FutureFunctor(IFunctor functor) {
            this.functor = functor;
        }

        public IFunctor getFunctor() {
            return this.functor;
        }

        public Object perform(IFunctorCall call) throws FunctorException {
            Object result = this.functor.perform(call);
            return Promise.newFinished(result);
        }
    }
}

