/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ConstantFunctor;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationElement;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.functor.IFunctor;
import java.util.Iterator;

public class ArgumentDeclaration
extends DeclarationElement
implements IArgumentDeclaration,
IDeclarationSupport {
    public static final Object VALUE_UNDEFINED = new Object();
    private IFunctor defaultFunctor;
    private Object defaultValue;
    private Class type;
    private final DeclarationBlock declarationBlock;

    protected static ArgumentDeclaration basicDeclare(IDeclarationBlock declarationBlock, String pPath, String pModifiers, Object pDefaultValue, IFunctor pDefaultFunctor, Class pType, String description) throws DeclarationException {
        String[] segments = ".".equals(pPath) ? new String[]{"."} : pPath.split("\\.");
        IDeclarationBlock currentBlock = declarationBlock;
        IDeclarationElement declarationElement = null;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            declarationElement = currentBlock.getDeclarationElement(segment);
            if (declarationElement == null) {
                declarationElement = new ArgumentDeclaration(currentBlock.getDeclarationContext(), segment, null);
                currentBlock.addDeclarationElement(declarationElement);
            }
            if (declarationElement instanceof IDeclarationBlock) {
                currentBlock = (IDeclarationBlock)((Object)declarationElement);
                continue;
            }
            if (declarationElement instanceof IDeclarationSupport) {
                currentBlock = ((IDeclarationSupport)((Object)declarationElement)).getDeclarationBlock();
                continue;
            }
            throw new DeclarationException("unexpected declaration element");
        }
        if (declarationElement instanceof ArgumentDeclaration) {
            ArgumentDeclaration argumentDeclaration = (ArgumentDeclaration)declarationElement;
            argumentDeclaration.setModifierString(pModifiers);
            argumentDeclaration.setType(pType);
            if (pDefaultFunctor == null) {
                ArgumentDeclaration.declareDefaultValue(argumentDeclaration, pDefaultValue);
            } else {
                argumentDeclaration.setDefaultFunctor(pDefaultFunctor);
            }
            argumentDeclaration.setDescription(description);
            return argumentDeclaration;
        }
        throw new DeclarationException("unexpected declaration element");
    }

    public static ArgumentDeclaration declareConstant(IDeclarationBlock declarationBlock, String pPath, String pModifiers, Object pDefaultValue, Class pType) throws DeclarationException {
        return ArgumentDeclaration.declareConstant(declarationBlock, pPath, pModifiers, pDefaultValue, pType, null);
    }

    public static ArgumentDeclaration declareConstant(IDeclarationBlock declarationBlock, String pPath, String pModifiers, Object pDefaultValue, Class pType, String description) throws DeclarationException {
        return ArgumentDeclaration.basicDeclare(declarationBlock, pPath, pModifiers, pDefaultValue, null, pType, description);
    }

    protected static void declareDefaultValue(ArgumentDeclaration argumentDeclaration, Object pDefaultValue) throws DeclarationException {
        if (pDefaultValue instanceof IArgs) {
            IArgs argsValue = (IArgs)pDefaultValue;
            IDeclarationBlock declarationBlock = argumentDeclaration.getDeclarationBlock();
            int index = 0;
            Iterator<IArgs.IBinding> i = argsValue.bindings();
            while (i.hasNext()) {
                IArgs.IBinding binding = i.next();
                String name = binding.getName();
                if (name == null) {
                    name = String.valueOf(index);
                }
                ArgumentDeclaration.declareConstant(declarationBlock, name, null, binding.getValue(), null);
                ++index;
            }
        } else {
            argumentDeclaration.setDefaultValue(pDefaultValue);
        }
    }

    public static ArgumentDeclaration declareFunctor(IDeclarationBlock declarationBlock, String pPath, String pModifiers, IFunctor pDefaultFunctor, Class pType, String description) throws DeclarationException {
        return ArgumentDeclaration.basicDeclare(declarationBlock, pPath, pModifiers, null, pDefaultFunctor, pType, description);
    }

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers) {
        this(declarationContext, name, modifiers, null);
    }

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers, Object defaultValue, Class type) {
        this(declarationContext, name, modifiers, defaultValue, type, null);
    }

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers, Object defaultValue, Class type, String description) {
        super(declarationContext, name, modifiers, description);
        this.declarationBlock = new DeclarationBlock(declarationContext);
        this.setDefaultValue(defaultValue);
        this.setType(type);
    }

    protected ArgumentDeclaration(Object declarationContext, String name, String modifiers, Object defaultValue, IFunctor defaultFunctor, Class type, DeclarationBlock block) {
        super(declarationContext, name, modifiers);
        this.defaultValue = defaultValue;
        this.defaultFunctor = defaultFunctor;
        this.setType(type);
        this.declarationBlock = block;
    }

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers, String description) {
        super(declarationContext, name, modifiers, description);
        this.declarationBlock = new DeclarationBlock(declarationContext);
        this.defaultFunctor = null;
        this.defaultValue = VALUE_UNDEFINED;
        this.setType(Object.class);
    }

    @Override
    public ArgumentDeclaration copy() {
        return new ArgumentDeclaration(this.getDeclarationContext(), this.getName(), this.getModifierString(), this.defaultValue, this.defaultFunctor, this.getType(), (DeclarationBlock)this.getDeclarationBlock().copy());
    }

    public ArgumentDeclaration declare(String pName, String pModifiers, Object pDefaultValue, Class pType) {
        ArgumentDeclaration newDeclaration = new ArgumentDeclaration(this.getDeclarationContext(), pName, pModifiers, pDefaultValue, pType);
        this.getDeclarationBlock().addDeclarationElement(newDeclaration);
        return newDeclaration;
    }

    @Override
    public IDeclarationBlock getDeclarationBlock() {
        return this.declarationBlock;
    }

    public IFunctor getDefaultFunctor() {
        return this.defaultFunctor;
    }

    public String getDefaultLabel() {
        if (this.defaultValue == VALUE_UNDEFINED) {
            if (this.defaultFunctor instanceof ConstantFunctor) {
                return String.valueOf(((ConstantFunctor)this.defaultFunctor).getConstant());
            }
            if (this.defaultFunctor == null) {
                return "";
            }
            return String.valueOf(this.defaultFunctor);
        }
        return String.valueOf(this.defaultValue);
    }

    @Override
    public Object getDefaultValue(IArgs scope) throws FunctorException {
        if (this.declarationBlock.size() > 0) {
            return Args.create();
        }
        if (this.defaultValue != VALUE_UNDEFINED) {
            return this.defaultValue;
        }
        if (this.getDefaultFunctor() != null) {
            return this.getDefaultFunctor().perform(new FunctorCall(null, scope));
        }
        return null;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return this.getType().getName();
    }

    @Override
    public boolean isDefaultDefined() {
        if (this.defaultValue == VALUE_UNDEFINED) {
            return this.defaultFunctor != null;
        }
        return true;
    }

    public void setDefaultFunctor(IFunctor defaultFunctor) {
        this.defaultFunctor = defaultFunctor;
        this.defaultValue = VALUE_UNDEFINED;
        if (defaultFunctor != null) {
            this.declarationBlock.clear();
        }
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultFunctor = null;
        if (defaultValue != VALUE_UNDEFINED) {
            this.declarationBlock.clear();
        }
    }

    public void setDefaultValueUndefined() {
        this.defaultValue = VALUE_UNDEFINED;
        this.defaultFunctor = null;
    }

    public void setType(Class pType) {
        if (pType == null || pType == IArgs.class) {
            pType = Object.class;
        }
        this.type = pType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTypeLabel());
        sb.append(" ");
        if (this.getModifierString() != null) {
            sb.append(this.getModifierString());
            sb.append(" ");
        }
        sb.append(this.getName());
        if (this.isDefaultDefined()) {
            sb.append(" = ");
            try {
                sb.append(this.getDefaultValue(Args.create()));
            }
            catch (FunctorException e) {
                sb.append("<evaluation error>");
            }
        }
        sb.append(";");
        for (IDeclarationElement element : this.getDeclarationBlock().getDeclarationElements()) {
            String[] lines;
            for (String line : lines = element.toString().split("\\n")) {
                sb.append("\n\t");
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

