/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArgsPrinter {
    private static final Object PRESENT = new Object();
    private Map<Object, Object> visited = new IdentityHashMap<Object, Object>();
    private int nesting = 0;
    private final Set<String> hidden = new HashSet<String>();

    public ArgsPrinter hide(String name) {
        this.hidden.add(name);
        return this;
    }

    protected void lineBegin(String prefix, StringBuilder sb) {
        sb.append(prefix);
        for (int i = 1; i < this.nesting; ++i) {
            sb.append("   ");
        }
    }

    public String toPrintString(IArgs args, String prefix) {
        StringBuilder sb = new StringBuilder();
        this.lineBegin(prefix, sb);
        this.toPrintStringValueArgs(prefix, sb, args);
        return sb.toString();
    }

    protected void toPrintStringValue(String prefix, StringBuilder sb, Object value) {
        if (value instanceof IArgs) {
            this.toPrintStringValueArgs(prefix, sb, (IArgs)value);
        } else {
            this.toPrintStringValuePlain(sb, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toPrintStringValueArgs(String prefix, StringBuilder sb, IArgs args) {
        String tokenClose;
        String tokenOpen;
        if (this.visited.get(args) != null) {
            sb.append("...recursive...");
            return;
        }
        if (this.nesting > 20) {
            sb.append("...nested to deep...");
            return;
        }
        this.visited.put(args, PRESENT);
        boolean named = args.isNamed();
        if (named) {
            tokenOpen = "{";
            tokenClose = "}";
        } else {
            tokenOpen = "[";
            tokenClose = "]";
        }
        sb.append(tokenOpen);
        sb.append("\n");
        ++this.nesting;
        try {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                Object value = binding.getValue();
                this.lineBegin(prefix, sb);
                if (named) {
                    String name = binding.getName();
                    if (this.hidden.contains(name)) continue;
                    sb.append("\"");
                    sb.append(name);
                    sb.append("\"");
                    sb.append(": ");
                }
                this.toPrintStringValue(prefix, sb, value);
                if (it.hasNext()) {
                    sb.append(",");
                }
                sb.append("\n");
            }
        }
        finally {
            --this.nesting;
            this.lineBegin(prefix, sb);
            sb.append(tokenClose);
        }
    }

    protected void toPrintStringValuePlain(StringBuilder sb, Object value) {
        if (value != null) {
            sb.append("\"");
        }
        sb.append(StringTools.getLeading(StringTools.safeString(value), 10240));
        if (value != null) {
            sb.append("\"");
        }
    }
}

