/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IOutlet;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.proxy.IProxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class StandardOutlet
implements IOutlet {
    private final EventDispatcher dispatcher = new EventDispatcher(this);
    private final Map<String, IFactory<?>> factories = new LinkedHashMap();
    private final Function<IFactory<?>, IFactory<?>> fUnwrap = factory -> {
        if (factory instanceof IProxy) {
            return (IFactory)((IProxy)((Object)factory)).getRealized();
        }
        return factory;
    };
    private final INotificationListener<CreatedEvent> listenCreated = new INotificationListener<CreatedEvent>(){

        @Override
        public void handleEvent(CreatedEvent event) {
            StandardOutlet.this.onCreated(event);
        }
    };

    @Override
    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public synchronized void clear() {
        HashMap temp = new HashMap(this.factories);
        for (String id : temp.keySet()) {
            this.unregisterFactory(id);
        }
    }

    public synchronized IFactory[] getFactories() {
        return (IFactory[])this.factories.values().stream().map(this.fUnwrap).distinct().toArray(IFactory[]::new);
    }

    public synchronized IFactory[] lookupFactories(Class type) {
        Predicate<IFactory> accept = factory -> {
            Class resultType = factory.getResultType();
            return resultType != null && type.isAssignableFrom(resultType);
        };
        return (IFactory[])this.factories.values().stream().filter(accept).map(this.fUnwrap).distinct().toArray(IFactory[]::new);
    }

    @Override
    public synchronized IFactory<?> lookupFactory(String id) {
        IFactory<?> factory = this.factories.get(Aliases.get().resolve(id));
        return this.fUnwrap.apply(factory);
    }

    protected void onCreated(Event event) {
        this.triggerEvent(event);
    }

    @Override
    public synchronized void registerFactory(String id, IFactory<?> factory) {
        IFactory<?> oldFactory = this.factories.get(id);
        if (oldFactory != null) {
            throw new InvalidRequestException("IFactory '" + id + "' already registered");
        }
        this.factories.put(id, factory);
        if (factory instanceof INotificationSupport) {
            ((INotificationSupport)((Object)factory)).removeNotificationListener(CreatedEvent.ID, this.listenCreated);
            ((INotificationSupport)((Object)factory)).addNotificationListener(CreatedEvent.ID, this.listenCreated);
        }
        AttributeChangedEvent event = new AttributeChangedEvent(this, "factories", null, factory);
        this.triggerEvent(event);
    }

    @Override
    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    @Override
    public synchronized void unregisterFactory(String id) {
        IFactory<?> factory = this.factories.remove(id);
        if (factory != null) {
            if (factory instanceof INotificationSupport) {
                ((INotificationSupport)((Object)factory)).removeNotificationListener(CreatedEvent.ID, this.listenCreated);
            }
            AttributeChangedEvent event = new AttributeChangedEvent(this, "factories", null, factory);
            this.triggerEvent(event);
        }
    }
}

