/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.environment.file;

import de.intarsys.tools.environment.file.IFileEnvironment;
import java.io.File;

public class StandardFileEnvironment
implements IFileEnvironment {
    private final File baseDir;
    private final File dataDir;
    private final File profileDir;
    private final File workingDir;
    private final File tempDir;

    public StandardFileEnvironment() {
        this.baseDir = new File(System.getProperty("user.dir"));
        this.dataDir = this.profileDir = new File(System.getProperty("user.home"));
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.workingDir = new File(System.getProperty("user.dir"));
    }

    public StandardFileEnvironment(File pBaseDir, File pProfileDir) {
        this.baseDir = pBaseDir;
        this.dataDir = this.profileDir = pProfileDir;
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.workingDir = pBaseDir;
    }

    public StandardFileEnvironment(File pBaseDir, File pProfileDir, File pTempDir, File pWorkingDir) {
        this.baseDir = pBaseDir;
        this.dataDir = this.profileDir = pProfileDir;
        this.tempDir = pTempDir;
        this.workingDir = pWorkingDir;
    }

    public StandardFileEnvironment(File pBaseDir, File pProfileDir, File pDataDir, File pTempDir, File pWorkingDir) {
        this.baseDir = pBaseDir;
        this.profileDir = pProfileDir;
        this.dataDir = pDataDir;
        this.tempDir = pTempDir;
        this.workingDir = pWorkingDir;
    }

    public StandardFileEnvironment(String pBaseDir, String pProfileDir) {
        this(new File(pBaseDir), new File(pProfileDir));
    }

    public StandardFileEnvironment(String pBaseDir, String pProfileDir, String pTempDir, String pWorkingDir) {
        this(new File(pBaseDir), new File(pProfileDir), new File(pTempDir), new File(pWorkingDir));
    }

    public StandardFileEnvironment(String pBaseDir, String pProfileDir, String pDataDir, String pTempDir, String pWorkingDir) {
        this(new File(pBaseDir), new File(pProfileDir), new File(pDataDir), new File(pTempDir), new File(pWorkingDir));
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public File getProfileDir() {
        return this.profileDir;
    }

    @Override
    public File getTempDir() {
        return this.tempDir;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }
}

