/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.encoding;

import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public final class Base64 {
    private static final byte PAD = 61;
    private static final char[] BASE64CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] BASE64POSITIONS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static byte[] decode(byte[] bytes) throws IOException {
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static byte[] decode(byte[] bytes, int offset, int len) throws IOException {
        try {
            if (bytes == null) {
                return null;
            }
            int newSize = 0;
            int padSize = 0;
            for (int i = offset; i < len; ++i) {
                byte octet = bytes[i];
                if (octet == 32 || octet == 13 || octet == 10 || octet == 9) continue;
                if (BASE64POSITIONS[octet] != -1) {
                    if (padSize > 0) {
                        throw new IOException("Base64 invalid input data");
                    }
                    if (newSize + offset != i) {
                        bytes[newSize + offset] = octet;
                    }
                    ++newSize;
                    continue;
                }
                if (octet == 61) {
                    ++padSize;
                    continue;
                }
                if (padSize > 0) break;
                throw new IOException("Base64 invalid input data");
            }
            if (newSize == 0) {
                return new byte[0];
            }
            if (newSize % 4 == 1) {
                throw new IOException("Base64 invalid input data");
            }
            if ((newSize + padSize) % 4 != 0) {
                throw new IOException("Base64 invalid input data");
            }
            byte[] result = new byte[(newSize - 1) / 4 * 3 + (newSize - 1) % 4];
            int threeI = 0;
            int fourI = 0;
            while (threeI < result.length) {
                boolean padded4 = false;
                boolean padded3 = false;
                int bits = (BASE64POSITIONS[bytes[fourI]] << 18) + (BASE64POSITIONS[bytes[fourI + 1]] << 12);
                if (newSize > fourI + 2) {
                    bits += BASE64POSITIONS[bytes[fourI + 2]] << 6;
                    if (newSize > fourI + 3) {
                        bits += BASE64POSITIONS[bytes[fourI + 3]];
                    } else {
                        padded4 = true;
                    }
                } else {
                    padded4 = true;
                    padded3 = true;
                }
                result[threeI] = (byte)(bits >> 16);
                if (!padded3) {
                    result[threeI + 1] = (byte)(bits >> 8 & 0xFF);
                }
                if (!padded4) {
                    result[threeI + 2] = (byte)(bits & 0xFF);
                }
                threeI += 3;
                fourI += 4;
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("Base64 invalid byte sequence", e);
        }
    }

    public static byte[] decode(String inputString) throws IOException {
        if (inputString == null) {
            return null;
        }
        return Base64.decode(StringTools.toByteArray(inputString));
    }

    public static byte[] encode(byte[] bytes) {
        return Base64.encode(bytes, 0, bytes.length);
    }

    public static byte[] encode(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        byte[] result = new byte[(length + 2) / 3 * 4];
        int iTimesFour = 0;
        int iTimesThree = offset;
        while (iTimesFour < result.length) {
            boolean pad3 = false;
            boolean pad4 = false;
            int bits = bytes[iTimesThree] << 16 & 0xFF0000;
            if (offset + length > iTimesThree + 1) {
                bits |= bytes[iTimesThree + 1] << 8 & 0xFF00;
                if (offset + length > iTimesThree + 2) {
                    bits |= bytes[iTimesThree + 2] & 0xFF;
                } else {
                    pad4 = true;
                }
            } else {
                pad4 = true;
                pad3 = true;
            }
            result[iTimesFour] = (byte)BASE64CHARS[bits >> 18 & 0x3F];
            result[iTimesFour + 1] = (byte)BASE64CHARS[bits >> 12 & 0x3F];
            result[iTimesFour + 2] = (byte)(pad3 ? 61 : BASE64CHARS[bits >> 6 & 0x3F]);
            result[iTimesFour + 3] = (byte)(pad4 ? 61 : BASE64CHARS[bits & 0x3F]);
            iTimesFour += 4;
            iTimesThree += 3;
        }
        return result;
    }

    public static boolean isBase64(byte octect) {
        return octect == 32 || octect == 13 || octect == 10 || octect == 9 || octect == 61 || BASE64POSITIONS[octect] != -1;
    }

    private Base64() {
    }
}

