/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.ElementElementAdapter;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.xml.TransformerTools;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentDocumentAdapter
implements IDocument,
IStringEvaluatorAccess {
    private final Document document;
    private IStringEvaluator stringEvaluator;

    public DocumentDocumentAdapter(Document document) {
        this.document = document;
    }

    @Override
    public String asXML() {
        String string;
        StringWriter output = new StringWriter();
        try {
            TransformerTools.createSecureTransformerFactory().newTransformer().transform(new DOMSource(this.document), new StreamResult(output));
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                return "<error>";
            }
        }
        output.close();
        return string;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public IElement getRootElement() {
        return new ElementElementAdapter(this.document.getDocumentElement(), false, this.stringEvaluator);
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public void setRootElement(IElement element) {
        Element w3cElement = ((ElementElementAdapter)element).getElement();
        Element tempElement = (Element)this.document.importNode(w3cElement, true);
        Element oldElement = this.document.getDocumentElement();
        if (oldElement != null) {
            this.document.removeChild(oldElement);
        }
        this.document.appendChild(tempElement);
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
    }

    public String toString() {
        return this.asXML();
    }
}

