/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.xml.TransformerTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTools {
    private static DocumentBuilderFactory sharedDocumentBuilderFactory = DOMTools.createSecureDocumentBuilderFactory();
    private static XPathFactory sharedXPathFactory = DOMTools.createXPathFactory();

    public static Element createChild(Node parent, String namespaceUri, String defaultPrefix, String localName) {
        Document document = parent.getOwnerDocument();
        String prefix = parent.lookupPrefix(namespaceUri);
        Element child = DOMTools.createElement(document, namespaceUri, prefix == null ? defaultPrefix : prefix, localName);
        parent.appendChild(child);
        return child;
    }

    public static Element createChild(XMLCryptoContext context, Node parent, String namespaceUri, String localName) {
        Document document = parent.getOwnerDocument();
        Element child = DOMTools.createElement(context, document, namespaceUri, localName);
        parent.appendChild(child);
        return child;
    }

    public static String createDerivedId(String id, String suffix) {
        return id + "-" + suffix;
    }

    public static Document createDocument() {
        try {
            return sharedDocumentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException exception) {
            throw new IllegalStateException("Shared factory should be able to create a document builder", exception);
        }
    }

    public static Element createElement(Document document, String namespaceUri, String qualifiedName) {
        return document.createElementNS(namespaceUri, qualifiedName);
    }

    public static Element createElement(Document document, String namespaceUri, String prefix, String localName) {
        String qualifiedName = prefix == null ? localName : prefix + ":" + localName;
        return DOMTools.createElement(document, namespaceUri, qualifiedName);
    }

    public static Element createElement(XMLCryptoContext context, Document document, String namespaceUri, String localName) {
        String prefix = context.getNamespacePrefix(namespaceUri, null);
        String qualifiedName = prefix == null ? localName : prefix + ":" + localName;
        return document.createElementNS(namespaceUri, qualifiedName);
    }

    public static String createId(String prefix) {
        return prefix + "-" + UUID.randomUUID().toString();
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setNamespaceAware(true);
        return factory;
    }

    public static XPath createXPath() {
        return sharedXPathFactory.newXPath();
    }

    public static XPath createXPath(NamespaceContext nsContext) {
        XPath xPath = sharedXPathFactory.newXPath();
        xPath.setNamespaceContext(nsContext);
        return xPath;
    }

    public static XPathFactory createXPathFactory() {
        return XPathFactory.newInstance();
    }

    public static int getAttrInt(Element elem, String name, int defaultValue) {
        String value = elem.getAttribute(name);
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Iterator<Attr> getAttrIterator(Element element) {
        final NamedNodeMap nodes = element.getAttributes();
        return new Iterator<Attr>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < nodes.getLength();
            }

            @Override
            public Attr next() {
                if (this.i >= nodes.getLength()) {
                    throw new NoSuchElementException();
                }
                return (Attr)nodes.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String getAttrString(Element elem, String name, String defaultValue) {
        String value = elem.getAttribute(name);
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static Element getElementFirst(Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            return (Element)nodes.item(i);
        }
        return null;
    }

    public static Element getElementFirst(Element parent, String local) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(local)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getElementFirst(Element parent, String ns, String local) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(ns) || !node.getLocalName().equals(local)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getElementLast(Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            return (Element)nodes.item(i);
        }
        return null;
    }

    public static Element getElementLast(Element parent, String local) {
        NodeList nodes = parent.getChildNodes();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(local)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getElementLast(Element parent, String ns, String local) {
        NodeList nodes = parent.getChildNodes();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(ns) || !node.getLocalName().equals(local)) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getElements(Element parent) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            result.add((Element)nodes.item(i));
        }
        return result;
    }

    public static List<Element> getElements(Element parent, String local) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(local)) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static Map<String, String> getNamespaceDeclarations(Element element) {
        HashMap<String, String> namespaces = new HashMap<String, String>(10);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!"xmlns".equals(node.getPrefix())) continue;
            String nsName = node.getLocalName();
            String nsUri = node.getTextContent();
            namespaces.put(nsName, nsUri);
        }
        return namespaces;
    }

    public static Element getOrCreateChild(Element parent, String namespaceUri, String prefix, String localName) {
        Element child = DOMTools.getElementFirst(parent, localName);
        if (child == null) {
            child = DOMTools.createChild(parent, namespaceUri, prefix, localName);
        }
        return child;
    }

    public static Element getOrCreateChild(XMLCryptoContext context, Element parent, String namespaceUri, String localName) {
        Element child = DOMTools.getElementFirst(parent, localName);
        if (child == null) {
            Document document = parent.getOwnerDocument();
            child = DOMTools.createElement(context, document, namespaceUri, localName);
            parent.appendChild(child);
        }
        return child;
    }

    public static boolean hasElements(Element parent) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElements(Element parent, String local) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(local)) continue;
            return true;
        }
        return false;
    }

    public static Document parseDocument(byte[] value) throws IOException, SAXException {
        InputSource source = new InputSource(new ByteArrayInputStream(value));
        return DOMTools.parseDocument(source);
    }

    public static Document parseDocument(File file) throws IOException, SAXException {
        FileInputStream is = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(is, 10000);
        return DOMTools.parseDocument(bis, true);
    }

    protected static Document parseDocument(InputSource source) throws IOException, SAXException {
        try {
            return sharedDocumentBuilderFactory.newDocumentBuilder().parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("parser configuration error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocument(InputStream is, boolean close) throws IOException, SAXException {
        try {
            InputSource source = new InputSource(is);
            Document document = DOMTools.parseDocument(source);
            return document;
        }
        finally {
            if (close) {
                StreamTools.close(is);
            }
        }
    }

    public static Document parseDocument(Reader r) throws IOException, SAXException {
        InputSource source = new InputSource(r);
        return DOMTools.parseDocument(source);
    }

    public static Document parseDocument(String value) throws IOException, SAXException {
        InputSource source = new InputSource(new StringReader(value));
        return DOMTools.parseDocument(source);
    }

    public static Element parseElement(byte[] value) throws IOException, SAXException {
        return DOMTools.parseDocument(value).getDocumentElement();
    }

    public static Element parseElement(File file) throws IOException, SAXException {
        return DOMTools.parseDocument(file).getDocumentElement();
    }

    protected static Element parseElement(InputSource source) throws IOException, SAXException {
        return DOMTools.parseDocument(source).getDocumentElement();
    }

    public static Element parseElement(InputStream is, boolean close) throws IOException, SAXException {
        return DOMTools.parseDocument(is, close).getDocumentElement();
    }

    public static Element parseElement(String value) throws IOException, SAXException {
        return DOMTools.parseDocument(value).getDocumentElement();
    }

    public static Node selectNode(String expression, NamespaceContext nsContext, Object context) throws XPathExpressionException {
        XPath xPath = DOMTools.createXPath(nsContext);
        return (Node)xPath.evaluate(expression, context, XPathConstants.NODE);
    }

    public static Node selectNode(String expression, Object context) throws XPathExpressionException {
        XPath xPath = DOMTools.createXPath();
        return (Node)xPath.evaluate(expression, context, XPathConstants.NODE);
    }

    public static List<Node> selectNodes(String expression, NamespaceContext nsContext, Object context) throws XPathExpressionException {
        XPath xPath = DOMTools.createXPath(nsContext);
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList itResult = (NodeList)xPath.evaluate(expression, context, XPathConstants.NODESET);
        for (int i = 0; i < itResult.getLength(); ++i) {
            Node node = itResult.item(i);
            result.add(node);
        }
        return result;
    }

    public static List<Node> selectNodes(String expression, Object context) throws XPathExpressionException {
        XPath xPath = DOMTools.createXPath();
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList itResult = (NodeList)xPath.evaluate(expression, context, XPathConstants.NODESET);
        for (int i = 0; i < itResult.getLength(); ++i) {
            Node node = itResult.item(i);
            result.add(node);
        }
        return result;
    }

    public static void serialize(Node node, ILocator locator) throws TransformerException, IOException {
        try (OutputStream os = locator.getOutputStream();){
            DOMTools.serialize(node, new StreamResult(os));
        }
    }

    public static void serialize(Node node, OutputStream stream) throws TransformerException {
        DOMTools.serialize(node, new StreamResult(stream));
    }

    private static void serialize(Node node, Result result) throws TransformerException {
        Transformer transformer = TransformerTools.createSecureTransformerFactory().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        TransformerTools.setIndentAmount(transformer, 2);
        transformer.transform(new DOMSource(node), result);
    }

    public static void serialize(Node node, Writer writer) throws TransformerException {
        DOMTools.serialize(node, new StreamResult(writer));
    }

    public static void setIdAttribute(Element element, String qualifiedName, String value) {
        element.setAttribute(qualifiedName, value);
        element.setIdAttribute(qualifiedName, true);
    }

    public static void setIdAttributeNS(Element element, String namespaceURI, String qualifiedName, String value) {
        element.setAttributeNS(namespaceURI, qualifiedName, value);
        element.setIdAttributeNS(namespaceURI, qualifiedName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Document doc) {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            DOMTools.serialize((Node)doc, writer);
            String string = writer.toString();
            return string;
        }
        catch (TransformerException e) {
            String string = "<error>";
            return string;
        }
        finally {
            StreamTools.close(writer);
        }
    }

    private DOMTools() {
    }
}

