/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.ComponentInfo;
import de.intarsys.tools.component.JarOrDirFileFilter;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInfoCollector {
    private static final String SUFFIX_JAR = ".jar";
    private static final String PATH_SEPARATORS = ":;,";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final Logger Log = LoggerFactory.getLogger(ComponentInfoCollector.class);
    private final List<File> paths = new ArrayList<File>();
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
    private final ComponentInfo root;

    public ComponentInfoCollector() {
        this(new ComponentInfo());
    }

    public ComponentInfoCollector(ComponentInfo componentInfo) {
        this.root = componentInfo;
    }

    public void addClassLoader(ClassLoader loader) {
        this.classLoaders.add(loader);
    }

    public void addPath(File ... files) {
        for (File file : files) {
            this.getPaths().add(file);
        }
    }

    public void addPath(String ... paths) {
        for (String path : paths) {
            StringTokenizer tokenizer = new StringTokenizer(path, PATH_SEPARATORS, false);
            while (tokenizer.hasMoreTokens()) {
                File singlePath = new File(tokenizer.nextToken().trim());
                this.addPath(singlePath);
            }
        }
    }

    public void collect() throws IOException {
        Log.trace("component info loading...");
        Iterator<Object> i = this.getJars().iterator();
        while (i.hasNext()) {
            this.getComponentInfos(this.getRoot(), i.next());
        }
        i = this.getClassLoaders().iterator();
        while (i.hasNext()) {
            this.getComponentInfos(this.getRoot(), (ClassLoader)i.next());
        }
        Log.trace("component info loaded");
    }

    protected ComponentInfo createComponentInfo(ComponentInfo parent, URL url, String containerName, Attributes attributes) {
        ComponentInfo info = new ComponentInfo();
        info.setContainerName(containerName);
        info.setUrl(url);
        if (parent != null) {
            parent.addChild(info);
        }
        info.readFromManifestAttributes(attributes);
        return info;
    }

    protected void createComponentInfos(ComponentInfo parent, URL url, String containerName, Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        ComponentInfo tmpParent = this.createComponentInfo(parent, url, containerName, attributes);
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            attributes = entry.getValue();
            if (!this.isValidChildComponent(attributes)) continue;
            this.createComponentInfo(tmpParent, url, entry.getKey(), attributes);
        }
        Log.trace("component info loaded from {}", (Object)url);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    protected void getComponentInfos(ComponentInfo parent, ClassLoader loader) throws IOException {
        Enumeration<URL> e = loader.getResources(MANIFEST_FILE);
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            this.getComponentInfos(parent, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getComponentInfos(ComponentInfo parent, File jarFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                URL url = jarFile.toURI().toURL();
                String containerName = jarFile.getName();
                this.createComponentInfos(parent, url, containerName, manifest);
            }
        }
        catch (Exception ex) {
            Log.info("component info loading manifest from {} failed ({})", (Object)jarFile, (Object)ex.getMessage());
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getComponentInfos(ComponentInfo parent, URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            Manifest manifest = new Manifest(is);
            URL containerUrl = ClassTools.getContainerResourceUrl(url);
            String containerName = PathTools.getName(containerUrl.toString());
            this.createComponentInfos(parent, containerUrl, containerName, manifest);
        }
        catch (Exception ex) {
            Log.info("component info loading manifest from {} failed ({})", (Object)url, (Object)ex.getMessage());
        }
        finally {
            StreamTools.close(is);
        }
    }

    protected List<File> getJars() {
        ArrayList<File> jarList = new ArrayList<File>();
        for (File path : this.getPaths()) {
            jarList.addAll(this.getJars(path));
        }
        return jarList;
    }

    protected List<File> getJars(File path) {
        File[] files;
        ArrayList<File> jarList = new ArrayList<File>();
        if (path.isFile() && path.getPath().endsWith(SUFFIX_JAR)) {
            jarList.add(path);
        } else if (path.isDirectory() && (files = path.listFiles(new JarOrDirFileFilter())) != null) {
            for (int i = 0; i < files.length; ++i) {
                jarList.addAll(this.getJars(files[i]));
            }
        }
        return jarList;
    }

    public List getPaths() {
        return this.paths;
    }

    public ComponentInfo getRoot() {
        return this.root;
    }

    protected boolean isValidChildComponent(Attributes attributes) {
        return !StringTools.isEmpty(attributes.getValue("Implementation-Version"));
    }
}

