/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.Requester;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.presentation.IPresentationHandler;
import java.util.List;

public class RequestSelection<R, P extends IActivity<?>>
extends Requester<R, P> {
    private R initialSelection;
    private R selection;
    private List<R> values;
    private boolean showCategories;
    private IPresentationHandler presentationProvider;

    public static <T, P extends IActivity<?>> RequestSelection<T, P> create(P parent, IMessage title, List<T> values, T initialValue) {
        return RequestSelection.create(parent, title, values, initialValue, null, false);
    }

    public static <T, P extends IActivity<?>> RequestSelection<T, P> create(P parent, IMessage title, List<T> values, T initialValue, IMessage toggleMessage, boolean toggleValue) {
        RequestSelection<T, P> result = new RequestSelection<T, P>(parent);
        result.setTitle(title);
        result.setValues(values);
        result.setInitialSelection(initialValue);
        result.setToggleMessage(toggleMessage);
        result.setToggleValue(toggleValue);
        return result;
    }

    public static <T, P extends IActivity<?>> T requestSelection(P parent, IMessage title, List<T> values, T initialValue) {
        return RequestSelection.requestSelection(parent, title, values, initialValue, null, false);
    }

    public static <T, P extends IActivity<?>> T requestSelection(P parent, IMessage title, List<T> values, T initialValue, IMessage toggleMessage, boolean toggleValue) {
        RequestSelection<T, P> activity = RequestSelection.create(parent, title, values, initialValue, toggleMessage, toggleValue);
        IActivityView view = activity.enter();
        if (view != null && !view.isConcurrent()) {
            view.cancel();
        }
        return (T)activity.getAnyway();
    }

    public RequestSelection(P parent) {
        super(parent);
    }

    @Override
    protected R getDefaultResult() {
        return this.getSelection();
    }

    public R getInitialSelection() {
        return this.initialSelection;
    }

    public IPresentationHandler getPresentationProvider() {
        return this.presentationProvider;
    }

    public R getSelection() {
        return this.selection;
    }

    public List<R> getValues() {
        return this.values;
    }

    public boolean isShowCategories() {
        return this.showCategories;
    }

    public void setInitialSelection(R initialSelection) {
        this.initialSelection = initialSelection;
    }

    public void setPresentationProvider(IPresentationHandler presentationProvider) {
        this.presentationProvider = presentationProvider;
    }

    public void setSelection(R selection) {
        this.selection = selection;
    }

    public void setShowCategories(boolean showCategories) {
        this.showCategories = showCategories;
    }

    public void setValues(List<R> values) {
        this.values = values;
    }
}

