/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.client.core.service.to;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Stack;

public class PdfEntry {
    private boolean check = true;
    private List<PdfEntry> children = new ArrayList<PdfEntry>();
    private String chosenClient;
    private String chosenFileName;
    private boolean file;
    private byte[] filePart;
    private String name;
    private PdfEntry parent;

    public static void processNodes(PdfEntry root, String client) {
        HashSet<PdfEntry> seen = new HashSet<PdfEntry>();
        Stack<PdfEntry> stack = new Stack<PdfEntry>();
        stack.add(root);
        while (!stack.isEmpty()) {
            PdfEntry pdfEntry = (PdfEntry)stack.pop();
            if (seen.contains(pdfEntry)) continue;
            seen.add(pdfEntry);
            stack.addAll(pdfEntry.getChildren());
            pdfEntry.setChosenFileName("Signature " + pdfEntry.getName() + ".pdf");
            pdfEntry.setChosenClient(client);
        }
    }

    public PdfEntry(String name, boolean file) {
        this.name = Objects.requireNonNull(name);
        this.file = false;
    }

    public void addChild(PdfEntry child) {
        this.children.add(Objects.requireNonNull(child));
        child.setParent(this);
    }

    public List<PdfEntry> getChildren() {
        return this.children;
    }

    public String getChosenClient() {
        return this.chosenClient;
    }

    public String getChosenFileName() {
        return this.chosenFileName;
    }

    @Deprecated
    public String getChosenMandant() {
        return this.getChosenClient();
    }

    public byte[] getFilePart() {
        if (this.filePart == null && this.parent != null) {
            return this.parent.getFilePart();
        }
        return this.filePart;
    }

    public String getName() {
        return this.name;
    }

    public PdfEntry getParent() {
        return this.parent;
    }

    public boolean isCheck() {
        return this.check;
    }

    public boolean isFile() {
        return this.file;
    }

    public void print() {
        HashSet<PdfEntry> seen = new HashSet<PdfEntry>();
        Stack<PdfEntryWithIndent> stack = new Stack<PdfEntryWithIndent>();
        stack.add(new PdfEntryWithIndent(this, ""));
        while (!stack.isEmpty()) {
            PdfEntryWithIndent pdfEntryWithIndent = (PdfEntryWithIndent)stack.pop();
            PdfEntry pdfEntry = pdfEntryWithIndent.getEntry();
            String indent = pdfEntryWithIndent.getIndent();
            if (seen.contains(pdfEntry)) continue;
            seen.add(pdfEntry);
            pdfEntry.getChildren().forEach(child -> stack.add(new PdfEntryWithIndent((PdfEntry)child, indent + "   ")));
            System.out.print(indent);
            System.out.println(pdfEntry.getName());
        }
    }

    public void setCheck(boolean check) {
        if (this.file) {
            return;
        }
        this.check = check;
    }

    public void setChosenClient(String chosenClient) {
        this.chosenClient = chosenClient;
    }

    public void setChosenFileName(String chosenFileName) {
        this.chosenFileName = chosenFileName;
    }

    @Deprecated
    public void setChosenMandant(String chosenMandator) {
        this.setChosenClient(chosenMandator);
    }

    public void setFilePart(byte[] filePart) {
        this.filePart = filePart;
    }

    public void setParent(PdfEntry parent) {
        this.parent = parent;
    }

    private static class PdfEntryWithIndent {
        private PdfEntry entry;
        private String indent;

        public PdfEntryWithIndent(PdfEntry entry, String indent) {
            this.entry = entry;
            this.indent = indent;
        }

        public PdfEntry getEntry() {
            return this.entry;
        }

        public String getIndent() {
            return this.indent;
        }
    }
}

