/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ThreadContextAwareResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.observation.logback.LogbackObserver;
import de.intarsys.tools.valueholder.INamedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ObservationAppender
implements Appender<ILoggingEvent> {
    private final LogbackObserver observer;
    private final Appender<ILoggingEvent> appender;
    private String name;

    public ObservationAppender(String name, LogbackObserver observer, Appender<ILoggingEvent> appender) {
        this.name = name;
        this.observer = observer;
        this.appender = appender;
    }

    protected boolean accept(List<INamedValue> namedValues) {
        if (this.getObserver().getObservationFilter() != null) {
            return this.getObserver().getObservationFilter().accept(namedValues);
        }
        return true;
    }

    public void addError(String msg) {
    }

    public void addError(String msg, Throwable ex) {
    }

    public void addFilter(Filter<ILoggingEvent> newFilter) {
    }

    public void addInfo(String msg) {
    }

    public void addInfo(String msg, Throwable ex) {
    }

    public void addStatus(Status status) {
    }

    public void addWarn(String msg) {
    }

    public void addWarn(String msg, Throwable ex) {
    }

    public void clearAllFilters() {
    }

    protected ILoggingEvent createCopy(ILoggingEvent event, List<INamedValue> namedValues) {
        LoggingEvent newEvent = new LoggingEvent();
        newEvent.setArgumentArray(namedValues.toArray());
        if (event.hasCallerData()) {
            newEvent.setCallerData(event.getCallerData());
        }
        newEvent.setLevel(event.getLevel());
        Logger logger = LoggerFactory.getLogger((String)event.getLoggerName());
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        newEvent.setLoggerContext(logbackLogger.getLoggerContext());
        newEvent.setLoggerContextRemoteView(event.getLoggerContextVO());
        newEvent.setLoggerName(event.getLoggerName());
        List markers = event.getMarkerList();
        if (markers != null) {
            for (Marker marker : markers) {
                newEvent.addMarker(marker);
            }
        }
        newEvent.setMDCPropertyMap(event.getMDCPropertyMap());
        newEvent.setMessage(event.getMessage());
        newEvent.setThreadName(event.getThreadName());
        newEvent.setThrowableProxy((ThrowableProxy)event.getThrowableProxy());
        newEvent.setTimeStamp(event.getTimeStamp());
        return newEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(ILoggingEvent event) throws LogbackException {
        final List<INamedValue> namedValues = this.toNamedValues(event.getArgumentArray());
        ContainerResolver namedValueResolver = new ContainerResolver(){

            protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
                for (INamedValue namedValue : namedValues) {
                    if (!namedValue.getName().equals(expression)) continue;
                    return namedValue.get();
                }
                return null;
            }
        };
        MapResolver mapResolver = ThreadContextAwareResolver.attachMapResolver();
        mapResolver.put("observation", (Object)namedValueResolver);
        try {
            if (!this.accept(namedValues)) {
                return;
            }
            ILoggingEvent newEvent = event;
            if (this.getObserver().getObservationView() != null) {
                List<INamedValue> viewValues = this.getObserver().getObservationView().apply(namedValues);
                newEvent = this.createCopy(event, viewValues);
            }
            this.getAppender().doAppend((Object)newEvent);
        }
        finally {
            ThreadContextAwareResolver.detach((IStringEvaluator)mapResolver);
        }
    }

    public Appender<ILoggingEvent> getAppender() {
        return this.appender;
    }

    public Context getContext() {
        return null;
    }

    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return Collections.emptyList();
    }

    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public LogbackObserver getObserver() {
        return this.observer;
    }

    public boolean isStarted() {
        return false;
    }

    public void setContext(Context context) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
    }

    public void stop() {
    }

    protected List<INamedValue> toNamedValues(Object[] args) {
        ArrayList<INamedValue> namedValues = new ArrayList<INamedValue>();
        for (Object object : args) {
            if (!(object instanceof INamedValue)) continue;
            namedValues.add((INamedValue)object);
        }
        return namedValues;
    }
}

