/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.conversationsigner;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.jca.conversationsigner.ConversationSignerKeystoreSpi;
import de.intarsys.security.jca.conversationsigner.ConversationSignerSignatureSpi;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigester;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.concurrent.Future;

public class ConversationSignerProvider
extends Provider {
    private static final String KEYSTORE = "KeyStore";
    private static final String SIGNATURE = "Signature";
    private final transient ISigner signer;
    private final transient Promise<IConversation<ISignatureData>> signConversationPromise = new Promise();

    public ConversationSignerProvider(ISigner signer) {
        this(signer, signer.getClass().getName());
    }

    public ConversationSignerProvider(ISigner signer, String name) {
        super(name, 1.0, "");
        this.signer = signer;
    }

    @Override
    public synchronized Provider.Service getService(String type, String algorithm) {
        if (KEYSTORE.equals(type)) {
            return new Provider.Service(this, KEYSTORE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    return new ConversationSignerKeystoreSpi(ConversationSignerProvider.this.signer);
                }
            };
        }
        if (SIGNATURE.equals(type)) {
            String hashAlgorithmName = SignatureAlgorithm.deriveHashAlgorithmName((String)algorithm);
            final DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName);
            if (hashAlgorithm == null) {
                return null;
            }
            return new Provider.Service(this, SIGNATURE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    try {
                        IDigester digester = DigestTools.createDigester((String)hashAlgorithm.getCanonicalName());
                        return new ConversationSignerSignatureSpi(ConversationSignerProvider.this, digester);
                    }
                    catch (NoSuchAlgorithmException e) {
                        return null;
                    }
                }
            };
        }
        return super.getService(type, algorithm);
    }

    public IConversation<ISignatureData> getSignConversation() {
        try {
            return (IConversation)this.signConversationPromise.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Conversation.failed((Throwable)e);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected ISigner getSigner() {
        return this.signer;
    }

    public void handleInitSign(PrivateKey privateKey) {
    }

    public Future<ISignatureData> handleSign(IToBeSignedData data) {
        Promise signature = new Promise();
        IConversation c = this.getSigner().sign(data).thenApply(result -> {
            signature.finish(result);
            return result;
        });
        this.signConversationPromise.finish((Object)c);
        return signature;
    }
}

