/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.timestamp.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.timestamp.device.VirtualTimestampDeviceProvider;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TimestampTools {
    public static ITimestampCreator createTimestampCreator(Object object) throws ObjectCreationException {
        IDevice device = TimestampTools.createTimestampDevice(object);
        if (device == null) {
            return null;
        }
        return (ITimestampCreator)device.createApplication(ITimestampCreator.class.getName(), (IArgs)Args.create());
    }

    public static IDevice createTimestampDevice(Object object) throws ObjectCreationException {
        return DeviceTools.toDevice(VirtualTimestampDeviceProvider.class, object);
    }

    public static List<IDeviceProvider<?>> getDeviceProviders() {
        ArrayList result = new ArrayList();
        List<IDeviceProvider<?>> providers = DeviceProviderRegistry.get().getDeviceProviders();
        block0: for (IDeviceProvider<?> provider : providers) {
            List<IApplicationDescriptor> descriptors = provider.getApplicationDescriptors();
            for (IApplicationDescriptor descriptor : descriptors) {
                if (descriptor.getType() != ITimestampCreator.class) continue;
                result.add(provider);
                continue block0;
            }
        }
        return result;
    }

    public static List<IDevice> getDevices() {
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        List<IDeviceProvider<?>> providers = TimestampTools.getDeviceProviders();
        for (IDeviceProvider<?> provider : providers) {
            Iterator<?> devices = provider.listDevices(null);
            ListTools.addAll(result, devices);
        }
        return result;
    }

    public static IDevice lookupDevice(String id) {
        if (id == null) {
            return null;
        }
        List<IDevice> devices = TimestampTools.getDevices();
        for (IDevice device : devices) {
            if (!id.equals(device.getId())) continue;
            return device;
        }
        return null;
    }
}

