/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.key;

import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreator;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreatorFactory;
import de.intarsys.security.device.key.CertificateSigner;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.UUID;

public class DefaultCertifier
implements IPublicKeyCertifier {
    @Override
    public IX509PublicKeyCertificate certify(PublicKey publicKey, Throwing.Specific.Supplier<ISigner, Exception> privateKeySigner) throws SecurityApplicationException {
        try {
            ISigner signer = (ISigner)privateKeySigner.get();
            if (!signer.isBasic()) {
                throw new IllegalStateException("signer must be on basic level");
            }
            try {
                ((IAuthenticatedApplication)((Object)signer)).authenticate().get();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot authenticate with signer app: " + e.getMessage(), e);
            }
            CertificateSigner certificateSigner = new CertificateSigner(signer);
            Args certifierArgs = Args.create();
            GregorianCalendar calValidTo = new GregorianCalendar();
            ((Calendar)calValidTo).add(1, 1);
            certifierArgs.put("validTo", (Object)calValidTo.getTime());
            ArgTools.putPath((IArgs)certifierArgs, (String)"commonName", (Object)UUID.randomUUID().toString());
            ArgTools.putPath((IArgs)certifierArgs, (String)"certificateSigner", (Object)certificateSigner);
            X509PublicKeyCertificateCreator certificateCreator = (X509PublicKeyCertificateCreator)FactoryTools.createInstance(X509PublicKeyCertificateCreatorFactory.class, (IArgs)certifierArgs);
            certificateCreator.setKeyPair(new KeyPair(publicKey, null));
            KeyCertificatePair keyCertPair = certificateCreator.createEntity();
            return keyCertPair.getCertificate();
        }
        catch (Exception e) {
            throw new SecurityApplicationException(e);
        }
    }
}

