/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceFilter;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IDeviceProviderRegistry;
import de.intarsys.security.device.common.AbstractDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CompositeDeviceProvider<T extends IDevice>
extends AbstractDeviceProvider<T>
implements IDeviceProviderRegistry,
IFactory<T> {
    private final List<IDeviceProvider<?>> deviceProviders = new ArrayList();
    private final INotificationListener<AttributeChangedEvent> listenAttributeChange = new INotificationListener<AttributeChangedEvent>(){

        public void handleEvent(AttributeChangedEvent event) {
            CompositeDeviceProvider.this.onAttributeChange(event);
        }
    };
    private final Object DEVICE_PROVIDER_WRITELOCK = new Object();

    public CompositeDeviceProvider() {
        this("composite");
    }

    public CompositeDeviceProvider(String id) {
        this.setId(id);
    }

    @Override
    protected void addNotificationDependencies() {
        super.addNotificationDependencies();
        ArrayList tempProviders = new ArrayList(this.deviceProviders);
        for (IDeviceProvider iDeviceProvider : tempProviders) {
            iDeviceProvider.addNotificationListener(AttributeChangedEvent.ID, this.listenAttributeChange);
        }
    }

    @Override
    public void clear() {
        this.deviceProviders.clear();
    }

    public T createInstance(IArgs args) throws ObjectCreationException {
        String id = ArgTools.getString((IArgs)args, (String)"id", null);
        if (id == null) {
            throw new ObjectCreationException("Missing argument id");
        }
        return DeviceTools.lookupDevice(this, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IApplicationDescriptor> getApplicationDescriptors() {
        ArrayList tempProviders;
        ArrayList<IApplicationDescriptor> items = new ArrayList<IApplicationDescriptor>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            tempProviders = new ArrayList(this.deviceProviders);
        }
        for (IDeviceProvider iDeviceProvider : tempProviders) {
            items.addAll(iDeviceProvider.getApplicationDescriptors());
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDeviceProvider<?>> getDeviceProviders() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.deviceProviders);
        }
    }

    public Class getResultType() {
        return IDevice.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> listDevices(IDeviceFilter filter) {
        ArrayList tempProviders;
        ArrayList<IDevice> items = new ArrayList<IDevice>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            tempProviders = new ArrayList(this.deviceProviders);
        }
        for (IDeviceProvider iDeviceProvider : tempProviders) {
            for (IDevice item : IterableTools.in(iDeviceProvider.listDevices(filter))) {
                items.add(item);
            }
        }
        return items.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDeviceProvider lookupDeviceProvider(String id) {
        ArrayList tempProviders;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            tempProviders = new ArrayList(this.deviceProviders);
        }
        for (IDeviceProvider iDeviceProvider : tempProviders) {
            if (!id.equals(iDeviceProvider.getId())) continue;
            return iDeviceProvider;
        }
        return null;
    }

    protected void onAttributeChange(AttributeChangedEvent event) {
        this.triggerEvent((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDeviceProvider(IDeviceProvider deviceProvider) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.deviceProviders.contains(deviceProvider)) {
                Object object2 = this.DEVICE_PROVIDER_WRITELOCK;
                synchronized (object2) {
                    this.deviceProviders.add(deviceProvider);
                }
                if (!this.getEventDispatcher().isEmpty()) {
                    deviceProvider.addNotificationListener(AttributeChangedEvent.ID, this.listenAttributeChange);
                }
                this.sortDeviceProvidersByPriority();
            }
        }
    }

    @Override
    protected void removeNotificationDependencies() {
        super.removeNotificationDependencies();
        ArrayList tempProviders = new ArrayList(this.deviceProviders);
        for (IDeviceProvider iDeviceProvider : tempProviders) {
            iDeviceProvider.removeNotificationListener(AttributeChangedEvent.ID, this.listenAttributeChange);
        }
    }

    private void sortDeviceProvidersByPriority() {
        if (this.deviceProviders.size() < 2) {
            return;
        }
        Collections.sort(this.deviceProviders, new Comparator<IDeviceProvider>(){

            @Override
            public int compare(IDeviceProvider o1, IDeviceProvider o2) {
                int p1 = 0;
                int p2 = 0;
                if (o1 instanceof CommonDeviceProvider) {
                    p1 = ((CommonDeviceProvider)o1).getPriority();
                }
                if (o2 instanceof CommonDeviceProvider) {
                    p2 = ((CommonDeviceProvider)o2).getPriority();
                }
                return -1 * Integer.compare(p1, p2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDeviceProvider(IDeviceProvider deviceProvider) {
        Object object = this.lock;
        synchronized (object) {
            deviceProvider.removeNotificationListener(AttributeChangedEvent.ID, this.listenAttributeChange);
            Object object2 = this.DEVICE_PROVIDER_WRITELOCK;
            synchronized (object2) {
                this.deviceProviders.remove(deviceProvider);
            }
        }
    }
}

