/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceFilter;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.infoset.ElementConfigurationProvider;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.reflect.InvocableArgument;
import de.intarsys.tools.reflect.InvocableMethod;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class AbstractDeviceProvider<T extends IDevice>
implements IDeviceProvider<T>,
IElementConfigurable,
Iterable<T> {
    public static final String ATTR_NOTICES = "notices";
    public static final String ARG_ID = "id";
    private static final Logger Log = LoggerFactory.getLogger(AbstractDeviceProvider.class);
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private String id;
    private final AttributeMap attributes = new AttributeMap();
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();
    private IElement configuration;
    protected final Object lock = new Object();

    protected AbstractDeviceProvider() {
    }

    public void addNotice(INotice notice) {
        this.basicAddNotice(notice);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, null, (Object)notice));
    }

    protected void addNotificationDependencies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Event> void addNotificationListener(EventType<? extends E> type, INotificationListener<E> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.eventDispatcher.addNotificationListener(type, listener);
            if (this.eventDispatcher.size() == 1) {
                this.addNotificationDependencies();
            }
        }
    }

    protected void basicAddNotice(INotice notice) {
        this.notices.add(notice);
    }

    protected void basicClearNotices() {
        this.notices.clear();
    }

    public void clearNotices() {
        this.basicClearNotices();
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, null, null));
    }

    public void configure(IElement element) throws ConfigurationException {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("configure " + this);
            Log.debug("configuration \n" + element);
        }
        this.configuration = element;
        this.setId(ElementTools.getString((IElement)element, (String)ARG_ID, (String)this.getId()));
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected IElement getConfiguration() {
        return this.configuration;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    @InvocableMethod
    public String getId() {
        return this.id;
    }

    public List<INotice> getNotices() {
        return this.notices;
    }

    @PostConstruct
    public void init() {
        IElement root = ElementConfigurationProvider.get().getRootElement();
        IElement tmpConfig = ElementTools.getPathElement((IElement)root, (String[])new String[]{"deviceProviders", this.getId()});
        if (this.configuration == null) {
            this.configuration = tmpConfig;
        } else {
            ElementTools.copy((IElement)this.configuration, (IElement)tmpConfig);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listDevices(null);
    }

    @Override
    public Iterator<T> listDevices(@InvocableArgument(name="filter") IDeviceFilter filter) {
        return Collections.emptyIterator();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public boolean removeNotice(INotice notice) {
        if (this.notices.remove(notice)) {
            this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, (Object)notice, null));
            return true;
        }
        return false;
    }

    protected void removeNotificationDependencies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Event> void removeNotificationListener(EventType<? extends E> type, INotificationListener<E> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.eventDispatcher.removeNotificationListener(type, listener);
            if (this.eventDispatcher.isEmpty()) {
                this.removeNotificationDependencies();
            }
        }
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.triggerEvent(event);
    }
}

