/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.ssl;

import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.jca.device.DevicePrivateKey;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.X509KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceKeyManager
implements X509KeyManager {
    private static final CheckType CHECK_TYPE_CLIENT = new CheckTypeClient();
    private static final CheckType CHECK_TYPE_SERVER = new CheckTypeServer();
    private static final Logger Log = LoggerFactory.getLogger(DeviceKeyManager.class);
    private final IDevice device;
    private List<String> unsupportedKeyTypes = new ArrayList<String>();
    private Secret password;

    public static DeviceKeyManager create(IDevice device) throws GeneralSecurityException, IOException {
        return new DeviceKeyManager(device);
    }

    private DeviceKeyManager(IDevice device) {
        this.device = device;
    }

    public void addUnsupportedKeyType(String type) {
        this.unsupportedKeyTypes.add(type);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        ArrayList types = this.createKeyTypes(keyType);
        return this.getKeyOwnerIds(types, CHECK_TYPE_CLIENT).findFirst().orElse(null);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        ArrayList types = this.createKeyTypes(keyType);
        return this.getKeyOwnerIds(types, CHECK_TYPE_SERVER).findFirst().orElse(null);
    }

    protected ArrayList createKeyTypes(String ... keyTypes) {
        if (keyTypes == null || keyTypes.length == 0 || keyTypes[0] == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(keyTypes));
        result.removeAll(this.unsupportedKeyTypes);
        return result;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        IX509Certificate[] certificatePath;
        IX509PublicKeyCertificate certificate;
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        if (principal.isPresent() && (certificate = principal.get().getX509PublicKeyCertificate()) != null && (certificatePath = ValidationTools.getCertificatePath((IX509Certificate)certificate, (boolean)true)) != null) {
            try {
                return CertificateTools.toJavaCerts((IX509Certificate[])certificatePath);
            }
            catch (CertificateException e) {
                Log.warn(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList types = this.createKeyTypes(keyType);
        return (String[])this.getKeyOwnerIds(types, CHECK_TYPE_CLIENT).toArray(String[]::new);
    }

    protected IDevice getDevice() {
        return this.device;
    }

    protected Stream<String> getKeyOwnerIds(List<String> types, CheckType checkType) {
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        return this.getPrincipalStream().filter(principal -> {
            if (!principal.isKeyOwner()) {
                return false;
            }
            IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
            if (certificate == null) {
                return false;
            }
            return types.contains(this.getSignatureAlgorithm(certificate));
        }).map(principal -> principal.getId());
    }

    public Secret getPassword() {
        return this.password;
    }

    protected Optional<IX509Principal> getPrincipal(String id) {
        return this.getPrincipalStream().filter(principal -> id.equals(principal.getId())).findFirst();
    }

    protected Stream<IX509Principal> getPrincipalStream() {
        IPrincipalFilter principalFilter = principal -> principal instanceof IX509Principal;
        return StreamingTools.asStream(this.device.listPrincipals(principalFilter)).map(IX509Principal.class::cast);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        return principal.filter(p -> p.isKeyOwner()).map(p -> DevicePrivateKey.create(this.device, p, this.getPassword())).orElse(null);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList types = this.createKeyTypes(keyType);
        return (String[])this.getKeyOwnerIds(types, CHECK_TYPE_SERVER).toArray(String[]::new);
    }

    protected String getSignatureAlgorithm(IX509PublicKeyCertificate certificate) {
        return certificate.getPublicKey().getAlgorithm();
    }

    public List<String> getUnsupportedKeyTypes() {
        return this.unsupportedKeyTypes;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setUnsupportedKeyTypes(List<String> unsupportedKeyTypes) {
        this.unsupportedKeyTypes = unsupportedKeyTypes;
    }

    public static class CheckType {
        public boolean check(IPrincipal principal, List<SNIServerName> serverNames) {
            return true;
        }
    }

    public static class CheckTypeClient
    extends CheckType {
    }

    public static class CheckTypeServer
    extends CheckType {
    }
}

