/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSigner;
import de.intarsys.security.app.signature.PACKAGE;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.monitor.Trace;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonSingleSigner
extends CommonSigner {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonSingleSigner.class);

    public CommonSingleSigner(CommonDevice device) {
        super(device);
    }

    @Override
    protected IConversation<?> basicSignAuthorized() {
        IConversation inner = Conversation.completed(null);
        for (SignatureTask task : this.getTasks()) {
            inner = inner.thenCompose(ignore -> this.basicSignAuthorizedSingle(task.toBeSignedData)).thenApply(signature -> {
                this.tasksComplete(task, (ISignatureData)signature);
                return task;
            });
        }
        return inner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<ISignatureData> basicSignAuthorizedSingle(IToBeSignedData data) {
        block10: {
            try {
                if (this.checkRestriction()) break block10;
                this.deauthenticate();
                try {
                    this.authenticate().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SecurityApplicationException("execution interrupted", e);
                }
                catch (ExecutionException e) {
                    throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
                }
            }
            catch (LicenseException e) {
                String msg = Msg.getString("CommonSigner.ExLicense", new Object[0]);
                return Conversation.failed((Throwable)new SecurityApplicationException(msg, e));
            }
            catch (SecurityApplicationException e) {
                return Conversation.failed((Throwable)e);
            }
            catch (Exception e) {
                return Conversation.failed((Throwable)new SecurityApplicationException(e));
            }
        }
        Trace.get().sample(Level.INFO, "enter signer ");
        try {
            IConversation<ISignatureData> iConversation = this.basicSignSingle(data);
            return iConversation;
        }
        finally {
            Trace.get().sample(Level.INFO, "leave signer ");
        }
    }

    protected abstract IConversation<ISignatureData> basicSignSingle(IToBeSignedData var1);
}

