/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationModule;
import de.intarsys.aaa.authenticate.module.composite.CompositeAuthenticationModule;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.app.signature.CommonSigner;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class CommonSignerFactory<D extends CommonDevice, T extends CommonSigner>
extends CommonSecurityApplicationFactory<D, T> {
    @Override
    protected void basicInitApp(T signer, IArgs args) throws ObjectCreationException {
        super.basicInitApp(signer, args);
        ((CommonSigner)signer).setProcessingMessage(ArgTools.getString((IArgs)args, (String)"processingMessage", null));
        ((CommonSigner)signer).setSignatureLabel(ArgTools.getString((IArgs)args, (String)"signatureLabel", null));
        ((CommonSigner)signer).setSignatureEvidence(this.createSignatureEvidence(args));
        ((CommonSigner)signer).setAuthorizationContext(this.createAuthorizationContext(args));
        int approximatedContainerSize = ArgTools.getIntStrict((IArgs)args, (String)"approximatedContainerSize", (int)-1);
        if (approximatedContainerSize >= 0) {
            ((CommonSigner)signer).setApproximatedContainerSize(approximatedContainerSize);
        }
    }

    protected IAuthenticationModule createAuthenticationModule(IArgs args) throws ObjectCreationException {
        CompositeAuthenticationModule authModule = new CompositeAuthenticationModule();
        authModule.initFromArgs(args);
        return authModule;
    }

    protected IAuthenticationContext createAuthorizationContext(IArgs args) throws ObjectCreationException {
        IAuthenticationModule authenticationModule = this.createAuthenticationModule(args);
        return authenticationModule.createContext(null);
    }

    protected SignatureEvidence createSignatureEvidence(IArgs args) throws ObjectCreationException {
        Object value = args.get("signatureEvidence");
        if (value == null) {
            return null;
        }
        if (value instanceof SignatureEvidence) {
            SignatureEvidence evidence = (SignatureEvidence)value;
            return evidence;
        }
        throw new ObjectCreationException("invalid argument");
    }
}

