/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.presentation.common;

import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.IPresentationSupportFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.util.HashSet;
import java.util.Set;

@SingletonProvider
public class PresentationSupportFactory
implements IPresentationSupportFactory {
    private final Set factories = new HashSet();

    public static PresentationSupportFactory get() {
        return (PresentationSupportFactory)ServiceLocator.get().get(PresentationSupportFactory.class);
    }

    public IPresentationSupport createPresentationSupport(Object object) {
        if (object instanceof IPresentationSupport) {
            return (IPresentationSupport)object;
        }
        for (IPresentationSupportFactory factory : this.factories) {
            IPresentationSupport result = factory.createPresentationSupport(object);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void registerPresentationSupportFactory(IPresentationSupportFactory factory) {
        this.factories.add(factory);
    }

    public void unregisterPresentationSupportFactory(IPresentationSupportFactory factory) {
        this.factories.remove(factory);
    }
}

