/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.preferences.common.ExtendedPreferences;
import de.intarsys.tools.preferences.common.ILocatorPreferencesPersistence;
import de.intarsys.tools.preferences.common.XMLPreferencesPersistence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LocatorPreferencesImpl
extends ExtendedPreferences {
    private ILocatorPreferencesPersistence persistence = new XMLPreferencesPersistence();
    private Map<String, LocatorPreferencesImpl> children = new HashMap<String, LocatorPreferencesImpl>();
    private ILocator locator;
    private final Map properties = new HashMap();
    private boolean changed;
    private boolean loaded;

    public LocatorPreferencesImpl(ExtendedPreferences parent, String name) {
        super(parent, name);
    }

    public void addNode(LocatorPreferencesImpl node) {
        this.children.put(node.name(), node);
    }

    protected Object basicPut(String key, String value) {
        this.setNewNodeFalse();
        String oldValue = this.properties.put(key, value);
        return oldValue;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        try {
            this.load();
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (LocatorPreferencesImpl child : this.children.values()) {
            if (child.newNode) continue;
            names.add(child.name());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LocatorPreferencesImpl child = this.children.computeIfAbsent(name, ignore -> {
            LocatorPreferencesImpl temp = new LocatorPreferencesImpl(this, name);
            temp.newNode = true;
            return temp;
        });
        return child;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Preferences) {
            try {
                Preferences other = (Preferences)obj;
                if (!this.name().equals(other.name())) {
                    return false;
                }
                String[] childrenNames = this.childrenNames();
                if (childrenNames.length != other.childrenNames().length) {
                    return false;
                }
                for (int i = 0; i < childrenNames.length; ++i) {
                    String childName = childrenNames[i];
                    if (this.node(childName).equals(other.node(childName))) continue;
                    return false;
                }
                String[] keyNames = this.keys();
                if (keyNames.length != other.keys().length) {
                    return false;
                }
                for (int i = 0; i < keyNames.length; ++i) {
                    String keyName = keyNames[i];
                    if (this.get(keyName, "").equals(other.get(keyName, ""))) continue;
                    return false;
                }
            }
            catch (BackingStoreException e) {
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public void flush() throws BackingStoreException {
        if (!this.isChanged()) {
            return;
        }
        try {
            LocatorPreferencesImpl root = this.getSerializationRoot();
            if (root != null) {
                root.save();
            }
            this.setChanged(false);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public Collection getNodes() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.children.values();
    }

    public ILocatorPreferencesPersistence getPersistence() {
        return this.persistence;
    }

    public Map getProperties() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.properties;
    }

    protected LocatorPreferencesImpl getSerializationRoot() {
        if (this.getLocator() == null) {
            if (this.parent() instanceof LocatorPreferencesImpl) {
                return ((LocatorPreferencesImpl)this.parent()).getSerializationRoot();
            }
            return null;
        }
        return this;
    }

    @Override
    protected String getSpi(String key) {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object result = this.properties.get(key);
        return result == null ? null : String.valueOf(result);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    protected boolean isChanged() {
        if (this.changed) {
            return true;
        }
        for (LocatorPreferencesImpl childPref : this.children.values()) {
            if (!childPref.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isRemoved() {
        return super.isRemoved();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        try {
            this.load();
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public void load() throws IOException {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.getPersistence() == null) {
            return;
        }
        if (this.getLocator() == null) {
            return;
        }
        this.getPersistence().loadPreferences(this, this.getLocator());
    }

    @Override
    protected void putSpi(String key, String value) {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object oldValue = this.basicPut(key, value);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setChanged(true);
        }
    }

    protected void removeNode(LocatorPreferencesImpl node) {
        if (!this.newNode) {
            this.setChanged(true);
        }
        this.children.remove(node.name());
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Preferences parent;
        if (!this.newNode) {
            this.setChanged(true);
        }
        if ((parent = this.parent()) instanceof LocatorPreferencesImpl) {
            ((LocatorPreferencesImpl)parent).removeNode(this);
        }
    }

    @Override
    protected void removeSpi(String key) {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setNewNodeFalse();
        Object value = this.properties.remove(key);
        if (value != null) {
            this.setChanged(true);
        }
    }

    protected void save() throws IOException {
        if (!this.loaded) {
            return;
        }
        if (this.getPersistence() == null) {
            return;
        }
        if (this.getLocator() == null) {
            return;
        }
        this.getPersistence().savePreferences(this, this.getLocator());
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setPersistence(ILocatorPreferencesPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public void sync() throws BackingStoreException {
        this.flush();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

