/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.jmx.IJMXNotificationSink;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class JMXNotificationBroker {
    private static final JMXNotificationBroker ACTIVE = new JMXNotificationBroker();
    private static final Logger Log = LoggerFactory.getLogger(JMXNotificationBroker.class);
    private final List<IJMXNotificationSink> notificationSinks = new ArrayList<IJMXNotificationSink>();
    private final NotificationListener listenMBeanServer = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (!(notification instanceof MBeanServerNotification)) {
                return;
            }
            JMXNotificationBroker.this.onMBeanServerNotification((MBeanServerNotification)notification);
        }
    };

    public static JMXNotificationBroker get() {
        return ACTIVE;
    }

    protected JMXNotificationBroker() {
        this.init();
    }

    public void addNotificationSink(IJMXNotificationSink sink) throws InstanceNotFoundException {
        this.notificationSinks.add(sink);
        MBeanServer server = this.getMBeanServer();
        if (server.isRegistered(sink.getObjectName())) {
            server.addNotificationListener(sink.getObjectName(), sink, sink.getNotificationFilter(), sink.getHandback());
        }
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public IJMXNotificationSink[] getNotificationSinks() {
        return this.notificationSinks.toArray(new IJMXNotificationSink[this.notificationSinks.size()]);
    }

    protected void init() {
        try {
            ObjectName serverName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            MBeanServer server = this.getMBeanServer();
            server.addNotificationListener(serverName, this.listenMBeanServer, null, null);
        }
        catch (Exception e) {
            Log.warn("error initializing NotificationBroker", (Throwable)e);
        }
    }

    protected List<IJMXNotificationSink> lookupNotificationSinks(ObjectName name) {
        ArrayList<IJMXNotificationSink> result = new ArrayList<IJMXNotificationSink>();
        for (IJMXNotificationSink sink : this.notificationSinks) {
            if (!name.equals(sink.getObjectName())) continue;
            result.add(sink);
        }
        return result;
    }

    protected void onMBeanServerNotification(MBeanServerNotification notification) {
        ObjectName name = notification.getMBeanName();
        MBeanServer server = this.getMBeanServer();
        if (server.isRegistered(name)) {
            List<IJMXNotificationSink> sinks = this.lookupNotificationSinks(name);
            for (IJMXNotificationSink sink : sinks) {
                try {
                    server.addNotificationListener(sink.getObjectName(), sink, sink.getNotificationFilter(), sink.getHandback());
                }
                catch (Exception e) {
                    Log.debug("JMX add notification listener failed", (Throwable)e);
                }
            }
        }
    }

    public void removeNotificationSink(IJMXNotificationSink sink) throws ListenerNotFoundException, InstanceNotFoundException {
        this.notificationSinks.remove(sink);
        MBeanServer server = this.getMBeanServer();
        server.removeNotificationListener(sink.getObjectName(), sink, sink.getNotificationFilter(), sink.getHandback());
    }
}

