/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;

public class LayoutOptions {
    public static final String ARG_SCALEWHEN = "scaleWhen";
    public static final String ARG_SCALEPROPORTIONAL = "scaleProportional";
    public static final String ARG_VALIGN = "vAlign";
    public static final String ARG_HALIGN = "hAlign";
    private EnumScaleWhen scaleWhen = (EnumScaleWhen)EnumScaleWhen.META.getDefault();
    private boolean scaleProportional = true;
    private EnumAlignment horizontalAlignment = EnumAlignment.START;
    private EnumAlignment verticalAlignment = EnumAlignment.START;

    public void fromArgs(IArgs args, String argsPrefix) {
        String tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_SCALEWHEN);
        this.setScaleWhen((EnumScaleWhen)ArgTools.getEnumItem((IArgs)args, EnumScaleWhen.META, (String)tempName));
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_HALIGN);
        this.setHorizontalAlignment(EnumAlignment.createFromArgs(args, tempName, EnumAlignment.START));
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_VALIGN);
        this.setVerticalAlignment(EnumAlignment.createFromArgs(args, tempName, EnumAlignment.START));
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_SCALEPROPORTIONAL);
        this.setScaleProportional(ArgTools.getBoolStrict((IArgs)args, (String)tempName, (boolean)true));
    }

    public EnumAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public EnumScaleWhen getScaleWhen() {
        return this.scaleWhen;
    }

    public EnumAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean isScaleProportional() {
        return this.scaleProportional;
    }

    public void setHorizontalAlignment(EnumAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setScaleProportional(boolean preserveProportions) {
        this.scaleProportional = preserveProportions;
    }

    public void setScaleWhen(EnumScaleWhen scaleWhen) {
        this.scaleWhen = scaleWhen;
    }

    public void setVerticalAlignment(EnumAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void toArgs(IArgs args, String argsPrefix) {
        String tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_SCALEWHEN);
        ArgTools.putPath((IArgs)args, (String)tempName, (Object)this.getScaleWhen().getId());
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_HALIGN);
        ArgTools.putPath((IArgs)args, (String)tempName, (Object)this.getHorizontalAlignment().getId());
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_VALIGN);
        ArgTools.putPath((IArgs)args, (String)tempName, (Object)this.getVerticalAlignment().getId());
        tempName = ArgTools.prefix((String)argsPrefix, (String)ARG_SCALEPROPORTIONAL);
        ArgTools.putPath((IArgs)args, (String)tempName, (Object)this.isScaleProportional());
    }

    public RectAlignment toRectAlignment() {
        EnumResize resize = this.scaleWhen.toResize();
        RectAlignment alignment = new RectAlignment();
        alignment.setHorizontalAlignment(this.horizontalAlignment);
        alignment.setHorizontalResize(resize);
        alignment.setVerticalAlignment(this.verticalAlignment);
        alignment.setVerticalResize(resize);
        alignment.setProportional(this.isScaleProportional());
        return alignment;
    }
}

