/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumResize;

public class EnumScaleWhen
extends EnumItem {
    public static final EnumScaleWhen ALWAYS = new EnumScaleWhen("always");
    public static final EnumMeta<EnumScaleWhen> META = EnumScaleWhen.getMeta(EnumScaleWhen.class);
    public static final EnumScaleWhen NEVER = new EnumScaleWhen("never");
    public static final EnumScaleWhen TOOBIG = new EnumScaleWhen("toobig");
    public static final EnumScaleWhen TOOSMALL = new EnumScaleWhen("toosmall");
    public static final EnumScaleWhen USER = new EnumScaleWhen("user");

    protected EnumScaleWhen(String id) {
        super(id);
    }

    public EnumScaleWhen forbidScaleNever() {
        if (this == ALWAYS || this == TOOSMALL) {
            return ALWAYS;
        }
        if (this == TOOBIG || this == NEVER) {
            return TOOBIG;
        }
        return this;
    }

    public boolean isScaleAlways() {
        return this == ALWAYS;
    }

    public boolean isScaleDown() {
        return this == TOOBIG;
    }

    public boolean isScaleDownAllowed() {
        return this.isScaleDown() || this.isScaleAlways();
    }

    public boolean isScaleNever() {
        return this == NEVER;
    }

    public boolean isScaleUp() {
        return this == TOOSMALL;
    }

    public boolean isScaleUpAllowed() {
        return this.isScaleUp() || this.isScaleAlways();
    }

    public boolean isUser() {
        return this == USER;
    }

    public EnumResize toResize() {
        if (this.isScaleAlways()) {
            return EnumResize.FILL;
        }
        if (this.isScaleDown()) {
            return EnumResize.SHRINK;
        }
        if (this.isScaleNever()) {
            return EnumResize.NEVER;
        }
        if (this.isScaleUp()) {
            return EnumResize.GROW;
        }
        return (EnumResize)EnumResize.META.getDefault();
    }

    static {
        TOOBIG.setDefault();
    }
}

