/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumHAlign;
import de.intarsys.tools.enumeration.common.EnumVAlign;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;

public class EnumAlignment
extends EnumItem
implements IAlignment {
    public static final EnumMeta<EnumAlignment> META = EnumAlignment.getMeta(EnumAlignment.class);
    public static final EnumAlignment START = new EnumAlignment("start", 0);
    public static final EnumAlignment CENTER = new EnumAlignment("center", 50);
    public static final EnumAlignment END = new EnumAlignment("end", 100);

    public static EnumAlignment createFrom(IAlignment alignment) {
        if (alignment == null) {
            return null;
        }
        if (alignment.isStart()) {
            return START;
        }
        if (alignment.isCenter()) {
            return CENTER;
        }
        return END;
    }

    public static EnumAlignment createFromArgs(IArgs args, String name, IAlignment defaultValue) {
        IAlignment tmpAlignment = (IAlignment)ArgTools.getEnumItem((IArgs)args, META, (String)name, (EnumItem)null);
        if (tmpAlignment == null) {
            tmpAlignment = (IAlignment)ArgTools.getEnumItem((IArgs)args, EnumHAlign.META, (String)name, (EnumItem)null);
        }
        if (tmpAlignment == null) {
            tmpAlignment = (IAlignment)ArgTools.getEnumItem((IArgs)args, EnumVAlign.META, (String)name, (EnumItem)null);
        }
        if (tmpAlignment == null) {
            tmpAlignment = defaultValue;
        }
        return EnumAlignment.createFrom(tmpAlignment);
    }

    protected EnumAlignment(String id, int weight) {
        super(id, weight);
    }

    @Override
    public int getWeight() {
        return super.getWeight();
    }

    @Override
    public boolean isCenter() {
        return this == CENTER;
    }

    @Override
    public boolean isEnd() {
        return this == END;
    }

    @Override
    public boolean isStart() {
        return this == START;
    }

    static {
        CENTER.setDefault();
    }
}

