/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authorization.acl;

import de.intarsys.aaa.authorization.acl.AccessControlEntry;
import de.intarsys.aaa.authorization.acl.IAclManager;
import de.intarsys.aaa.authorization.acl.SimpleAclManager;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.aaa.resource.SimpleOperation;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class AclEntryInstaller {
    @Autowired
    private IAclManager manager;
    private String authority;
    private String resource;
    private String operation;
    private boolean grant = true;

    public String getAuthority() {
        return this.authority;
    }

    public IAclManager getManager() {
        return this.manager;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getResource() {
        return this.resource;
    }

    @PostConstruct
    public void install() {
        SimpleObjectResource tmpResource = SimpleObjectResource.parse(this.getResource());
        SimpleOperation tmpOperation = SimpleOperation.parse(this.getOperation());
        String tmpAuthority = this.getAuthority();
        AccessControlEntry entry = new AccessControlEntry(tmpOperation, tmpAuthority, this.isGrant());
        this.getManager().getAccessControlList(tmpResource).addAccessControlEntry(entry);
    }

    public boolean isGrant() {
        return this.grant;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setGrant(boolean grant) {
        this.grant = grant;
    }

    public void setManager(SimpleAclManager manager) {
        this.manager = manager;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

