/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.module.composite;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.ICredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.api.ICredentialStore;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeCredentialProvider
implements ICredentialStore {
    private static final Logger Log = LoggerFactory.getLogger(CompositeCredentialProvider.class);
    private final List<ICredentialProvider> providers = new ArrayList<ICredentialProvider>();

    @Override
    public boolean acceptCredentialScope(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            if (!provider.acceptCredentialScope(scope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).clear();
        }
    }

    @Override
    public ICredential getCredential(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            Log.debug("requesting credentials for scope '{}' from provider {}", (Object)scope, (Object)provider);
            ICredential credential = provider.getCredential(scope);
            if (credential == null) continue;
            Log.debug("got credentials '{}' for scope '{}' from provider {}", new Object[]{credential, scope, provider});
            return credential;
        }
        return null;
    }

    public void registerCredentialProvider(ICredentialProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeCredential(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).removeCredential(scope);
        }
    }

    @Override
    public void setCredential(ICredentialScope scope, ICredential credential) {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).setCredential(scope, credential);
        }
    }
}

