/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.impl;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CredentialFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;

public class UserPasswordCredential
implements ICredential,
IElementSerializable {
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_QUALIFIED_USER_NAME = "qualifiedUserName";
    public static final String ATTR_USER = "user";
    private Secret secret;
    private String user;

    public UserPasswordCredential(String userName, Secret secret) {
        this.user = userName;
        this.secret = secret;
    }

    public Secret getPassword() {
        return this.secret;
    }

    public String getQualifiedUserName() {
        return this.getUser();
    }

    public Secret getSecret() {
        return this.secret;
    }

    public String getUser() {
        return this.user;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("factory", CredentialFactory.class.getName());
        element.setAttributeValue(ATTR_USER, this.user);
        ElementTools.putSecretTemplate((IElement)element, (String)ATTR_PASSWORD, (Secret)this.secret);
    }
}

