/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.impl;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationAdapter;
import de.intarsys.tools.string.StringTools;

public abstract class CommonAuthenticationState
implements IPresentationSupport {
    private static final Attribute ATTR_AUTH_STATE = new Attribute("AuthState");
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final IAttributeSupport attributes = new AttributeMap();
    private final CommonAuthenticationContext context;
    private final IConversation<CommonAuthenticationState> conversation;
    private final IArgs args;
    private String label;
    private String description;
    private ICredential credential;

    public static CommonAuthenticationState getAuthState(IAttributeSupport as) {
        if (as == null) {
            return null;
        }
        return (CommonAuthenticationState)as.getAttribute((Object)ATTR_AUTH_STATE);
    }

    public static void setAuthState(IAttributeSupport as, CommonAuthenticationState value) {
        if (as == null) {
            return;
        }
        as.setAttribute((Object)ATTR_AUTH_STATE, (Object)value);
    }

    protected CommonAuthenticationState(CommonAuthenticationContext context, IConversation<CommonAuthenticationState> conversation, IArgs args) {
        this.context = context;
        this.conversation = conversation;
        this.args = args;
        this.init();
    }

    public IArgs getArgs() {
        return this.args;
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public CommonAuthenticationContext getAuthenticationContext() {
        return this.context;
    }

    public IConversation<CommonAuthenticationState> getConversation() {
        return this.conversation;
    }

    public ICredential getCredential() {
        return this.credential;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTip() {
        return this.getLabel();
    }

    private void init() {
        this.updateLabel();
        this.updateDescription();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setCredential(ICredential credential) {
        this.credential = credential;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected void updateDescription() {
        String txt = ArgTools.getString((IArgs)this.args, (String)"description", null);
        if (StringTools.isEmpty((String)txt)) {
            txt = Msg.getString("CommonAuthenticationState.description", new Object[0]);
        }
        this.setDescription(txt);
    }

    protected void updateLabel() {
        String txt = ArgTools.getString((IArgs)this.args, (String)"label", null);
        if (StringTools.isEmpty((String)txt)) {
            IPresentationSupport ps = PresentationAdapter.create((Object)this.getAuthenticationContext().getAuthenticationModule().getCredentialSpec(), (String)this.getAuthenticationContext().getAuthenticationModule().getId());
            txt = Msg.getString("CommonAuthenticationState.label", new Object[]{ps.getLabel()});
        }
        this.setLabel(txt);
    }
}

