/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableProcessingException;
import de.intarsys.tools.table.TableProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProcessorLog<R>
extends TableProcessor<R> {
    private static final String SEPARATOR = ";";
    private static final String ATTR_LOGGER = "logger";
    private Logger log = LoggerFactory.getLogger(TableProcessorLog.class);
    private boolean formatShowHeader = true;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        String name = element.attributeValue(ATTR_LOGGER, this.getLog().getName());
        this.log = LoggerFactory.getLogger((String)name);
    }

    protected String convertToString(Object value) {
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])value)));
        }
        try {
            return (String)ConverterRegistry.get().convert(value, String.class);
        }
        catch (ConversionException e) {
            this.getLog().warn("table log conversion error", (Throwable)e);
            return "<conversion error>";
        }
    }

    protected String createHeader() throws TableProcessingException {
        StringBuilder sb = new StringBuilder();
        for (ITableColumn column : this.getActiveType().getColumns()) {
            if (sb.length() > 0) {
                sb.append(SEPARATOR);
            }
            String value = column.getName();
            sb.append(this.convertToString(value));
        }
        return sb.toString();
    }

    protected String createMessage(ITableRecord item) throws TableProcessingException {
        StringBuilder sb = new StringBuilder();
        for (ITableColumn column : this.getActiveType().getColumns()) {
            if (sb.length() > 0) {
                sb.append(SEPARATOR);
            }
            Object value = item.get(column.getName(), null);
            sb.append(this.convertToString(value));
        }
        return sb.toString();
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isFormatShowHeader() {
        return this.formatShowHeader;
    }

    @Override
    public void open(ITableType type) throws TableProcessingException {
        super.open(type);
        if (this.isFormatShowHeader()) {
            String msg = this.createHeader();
            this.getLog().info(msg);
        }
    }

    @Override
    public R process(ITableRecord item) throws TableProcessingException {
        if (item == null) {
            return null;
        }
        String msg = this.createMessage(item);
        this.getLog().info(msg);
        return super.process(item);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue(ATTR_LOGGER, this.getLog().getName());
    }

    public void setFormatShowHeader(boolean formatShowHeader) {
        this.formatShowHeader = formatShowHeader;
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

