/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp.pdfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.pdfa.PropertyPDFAProperty;
import org.jempbox.xmp.pdfa.PropertyPDFAValueType;
import org.jempbox.xmp.property.AbstractProperty;
import org.w3c.dom.Element;

public class PropertyPDFASchema
extends AbstractProperty {
    public static final String NAMESPACE = "http://www.aiim.org/pdfa/ns/schema#";
    protected static final String basePrefix = "pdfaSchema";
    public static List<String> propertyNames = Arrays.asList("pdfaSchema:schema", "pdfaSchema:namespaceURI", "pdfaSchema:prefix", "pdfaSchema:property", "pdfaSchema:valueType");

    public PropertyPDFASchema(Element element) {
        super(element, NAMESPACE, basePrefix);
    }

    public void addProperty(PropertyPDFAProperty property) {
        this.addSequenceValue("pdfaSchema:property", property);
    }

    public void addValueType(PropertyPDFAValueType vt) {
        this.addSequenceValue("pdfaSchema:valueType", vt);
    }

    public String getNamespaceURI() {
        return XMLUtil.getStringValue(this.parent, "pdfaSchema:namespaceURI");
    }

    public String getPrefix() {
        return XMLUtil.getStringValue(this.parent, "pdfaSchema:prefix");
    }

    public List<PropertyPDFAProperty> getProperties() {
        return this.getSequenceListForProperty("pdfaSchema:property");
    }

    public String getSchema() {
        return XMLUtil.getStringValue(this.parent, "pdfaSchema:schema");
    }

    protected List getSequenceListForProperty(String seqName) {
        List<Element> candidates = XMLUtil.getSeqListItems(this.parent, seqName);
        List<PropertyPDFAProperty> retval = new ArrayList();
        for (Element candidate : candidates) {
            retval.add(new PropertyPDFAProperty(candidate));
        }
        retval = Collections.unmodifiableList(retval);
        return retval;
    }

    protected List getSequenceListForValueType(String seqName) {
        List<Element> candidates = XMLUtil.getSeqListItems(this.parent, seqName);
        List<PropertyPDFAValueType> retval = new ArrayList();
        for (Element candidate : candidates) {
            retval.add(new PropertyPDFAValueType(candidate));
        }
        retval = Collections.unmodifiableList(retval);
        return retval;
    }

    public List<PropertyPDFAValueType> getValueTypes() {
        return this.getSequenceListForValueType("pdfaSchema:valueType");
    }

    public void removeProperty(PropertyPDFAProperty property) {
        this.removeSequenceValue("pdfaSchema:property", property);
    }

    public void removeValueType(PropertyPDFAValueType vt) {
        this.removeSequenceValue("pdfaSchema:valueType", vt);
    }

    public void setNamespaceURI(String uri) {
        XMLUtil.setStringValue(this.parent, "pdfaSchema:namespaceURI", uri);
    }

    public void setPrefix(String prefix) {
        XMLUtil.setStringValue(this.parent, "pdfaSchema:prefix", prefix);
    }

    public void setSchema(String schema) {
        XMLUtil.setStringValue(this.parent, "pdfaSchema:schema", schema);
    }
}

