/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.util.Arrays;
import java.util.List;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;

public class XMPSchemaRightsManagement
extends XMPSchema {
    public static final String NAMESPACE = "http://ns.adobe.com/xap/1.0/rights/";
    protected static final String basePrefix = "xmpRights";
    protected static final String basePrefixDepr = "xapRights";
    protected static List<String> propertyNames = Arrays.asList("xmpRights:Certificate", "xmpRights:Marked", "xmpRights:Owner", "xmpRights:UsageTerms", "xmpRights:WebStatement", "xapRights:Certificate", "xapRights:Marked", "xapRights:Owner", "xapRights:UsageTerms", "xapRights:WebStatement");

    public XMPSchemaRightsManagement(Element element, String prefix) {
        super(element, prefix);
    }

    public XMPSchemaRightsManagement(XMPMetadata parent) {
        super(parent, basePrefix, NAMESPACE);
    }

    public void addOwner(String owner) {
        this.addBagValue(this.prefix + ":Owner", owner);
    }

    public String getCertificateURL() {
        return this.getTextProperty(this.prefix + ":Certificate");
    }

    public String getCopyright() {
        return this.getTextProperty(this.prefix + ":Copyright");
    }

    public Boolean getMarked() {
        return this.getBooleanProperty(this.prefix + ":Marked");
    }

    public List getOwners() {
        return this.getBagList(this.prefix + ":Owner");
    }

    @Override
    protected List<String> getPropertyNames() {
        return propertyNames;
    }

    public String getUsageTerms() {
        return this.getLanguageProperty(this.prefix + ":UsageTerms", null);
    }

    public String getUsageTerms(String language) {
        return this.getLanguageProperty(this.prefix + ":UsageTerms", language);
    }

    public List getUsageTermsLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":UsageTerms");
    }

    public String getWebStatement() {
        return this.getTextProperty(this.prefix + ":WebStatement");
    }

    public void removeOwner(String owner) {
        this.removeBagValue(this.prefix + ":Ownder", owner);
    }

    public void setCertificateURL(String certificate) {
        this.setTextProperty(this.prefix + ":Certificate", certificate);
    }

    public void setCopyright(String copyright) {
        this.setTextProperty(this.prefix + ":Copyright", copyright);
    }

    public void setDescription(String language, String terms) {
        this.setLanguageProperty(this.prefix + ":UsageTerms", language, terms);
    }

    public void setMarked(Boolean marked) {
        this.setBooleanProperty(this.prefix + ":Marked", marked);
    }

    public void setUsageTerms(String terms) {
        this.setLanguageProperty(this.prefix + ":UsageTerms", null, terms);
    }

    public void setWebStatement(String webStatement) {
        this.setTextProperty(this.prefix + ":WebStatement", webStatement);
    }
}

