/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.sdk;

import ch.admin.suis.client.core.service.to.FileRequest;
import ch.admin.suis.client.core.service.to.StreamRequest;
import ch.admin.suis.validator.rest.to.AdditionalInfosTO;
import ch.admin.suis.validator.rest.to.ServiceInput;
import ch.admin.suis.validator.rest.to.SignatureTO;
import ch.admin.suis.validator.rest.to.ValidationData;
import ch.admin.suis.validator.rest.to.response.ValidatableFile;
import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDDSS;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationContextFactory;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.signature.PDFTimestampEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.ArgsBuilder;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInputBuilder {
    private static final Logger Log = LoggerFactory.getLogger(ServiceInputBuilder.class);
    private final List<IRequest> requests = new ArrayList<IRequest>();
    private String fieldName;
    private String language;
    private boolean pdfReport;
    private String pdfReportName;
    private String zipReportName;
    private boolean processUnsignedFiles;
    private String userName;
    private String userOrganization;

    public ServiceInputBuilder addCmsBytes(CMSSignedData pkcs7, byte[] signatureDigest, String client) {
        this.requests.add(new CmsRequest(pkcs7, signatureDigest, client));
        return this;
    }

    public ServiceInputBuilder addDocumentBytes(byte[] bytes, String name, String client) {
        this.requests.add(new LocatorRequest((ILocator)new ByteArrayLocator(bytes, name), client));
        return this;
    }

    public ServiceInputBuilder addFileRequests(List<FileRequest> fileRequests) {
        fileRequests.forEach(fileRequest -> this.requests.add(new LocatorRequest((ILocator)new FileLocator(fileRequest.getFile()), fileRequest.getClient())));
        return this;
    }

    public ServiceInputBuilder addStreamRequests(List<StreamRequest> streamRequests) throws IOException {
        for (StreamRequest streamRequest : streamRequests) {
            byte[] bytes = StreamTools.getBytes((InputStream)streamRequest.getStream());
            this.requests.add(new LocatorRequest((ILocator)new ByteArrayLocator(bytes, streamRequest.getFileName()), streamRequest.getClient()));
        }
        return this;
    }

    public ServiceInput build() throws IOException, NoSuchAlgorithmException {
        ServiceInput serviceInput = new ServiceInput();
        serviceInput.setLanguage(this.language);
        serviceInput.setPdfOutputFileName(this.pdfReportName);
        serviceInput.setPdfReport(this.pdfReport);
        serviceInput.setProcessUnsignedFiles(this.processUnsignedFiles);
        serviceInput.setUserName(this.userName);
        serviceInput.setUserOrganization(this.userOrganization);
        serviceInput.setZipOutputFileName(this.zipReportName);
        ArrayList<ValidatableFile> validatableFiles = new ArrayList<ValidatableFile>();
        for (IRequest request : this.requests) {
            validatableFiles.add(this.buildValidatableFile(request));
        }
        if (!this.processUnsignedFiles && validatableFiles.stream().noneMatch(validatableFile -> !validatableFile.getSignatures().isEmpty())) {
            throw new IllegalArgumentException("No files given contain a signature!");
        }
        serviceInput.setValidatableFiles(validatableFiles);
        return serviceInput;
    }

    protected SignatureTO buildSignatureTO(IRequestSignature signature, int index) throws IOException, NoSuchAlgorithmException {
        SignatureTO signatureTO = new SignatureTO();
        signatureTO.setChangeLevel(signature.getChangeLevel());
        signatureTO.setSignatureContent(signature.getSignatureContent());
        signatureTO.setSignatureDate(signature.getSignatureDate());
        signatureTO.setSignatureDigest(signature.getSignatureDigest());
        signatureTO.setSignatureName(signature.getSignatureName());
        signatureTO.setAdditionalInfos(signature.getAdditionalInfos());
        signatureTO.setSignaturePosition(Integer.valueOf(index));
        signatureTO.setContainsCrucialChanges(signature.containsCrucialChanges());
        signatureTO.setContainsVisualChanges(signature.containsVisualChanges());
        if (signature.isTimestamp()) {
            signatureTO.setType(SignatureTO.SignatureType.TIMESTAMP);
        }
        return signatureTO;
    }

    protected ValidatableFile buildValidatableFile(IRequest request) throws NoSuchAlgorithmException, IOException {
        ValidatableFile validatableFile = new ValidatableFile();
        validatableFile.setDocumentName(request.getDocumentName());
        validatableFile.setDocumentHash(request.getDocumentHash());
        validatableFile.setClient(request.getClient());
        ArrayList<SignatureTO> signatures = new ArrayList<SignatureTO>();
        List<IRequestSignature> requestSignatures = request.getSignatures();
        validatableFile.setMdpPermission(request.getMdpPermission().getValue());
        for (int index = 0; index < requestSignatures.size(); ++index) {
            IRequestSignature requestSignature = requestSignatures.get(index);
            if (this.fieldName != null && !this.fieldName.equals(requestSignature.getSignatureName())) continue;
            signatures.add(this.buildSignatureTO(requestSignature, index));
        }
        if (this.fieldName != null && signatures.isEmpty()) {
            throw new IllegalArgumentException("Signaturefield with name " + this.fieldName + " doesn't exist");
        }
        validatableFile.setSignatures(signatures);
        PDDSS dss = request.getDocumentDSS();
        if (dss != null) {
            ValidationData validationData = new ValidationData();
            validationData.setOcsp(Arrays.asList(dss.getOCSPs()));
            validationData.setCrl(Arrays.asList(dss.getCRLs()));
            validationData.setCertificates(Arrays.asList(dss.getCerts()));
            validatableFile.setValidationData(validationData);
        }
        return validatableFile;
    }

    public ServiceInputBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public ServiceInputBuilder language(String language) {
        this.language = language;
        return this;
    }

    public ServiceInputBuilder pdfReport(boolean pdfReport) {
        this.pdfReport = pdfReport;
        return this;
    }

    public ServiceInputBuilder pdfReportName(String pdfReportName) {
        this.pdfReportName = pdfReportName;
        return this;
    }

    public ServiceInputBuilder processUnsignedFiles(boolean processUnsignedFiles) {
        this.processUnsignedFiles = processUnsignedFiles;
        return this;
    }

    public ServiceInputBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public ServiceInputBuilder userOrganization(String userOrganization) {
        this.userOrganization = userOrganization;
        return this;
    }

    public ServiceInputBuilder zipReportName(String zipReportName) {
        this.zipReportName = zipReportName;
        return this;
    }

    public static class CmsRequest
    implements IRequest {
        private final String client;
        private final CMSSignedData pkcs7;
        private final byte[] signatureDigest;

        public CmsRequest(CMSSignedData pkcs7, byte[] signatureDigest, String client) {
            this.pkcs7 = pkcs7;
            this.signatureDigest = signatureDigest;
            this.client = client;
        }

        protected int getChangeLevel(IVSSignatureContainerEntry entryState) {
            if (entryState instanceof IVSSignatureEntry) {
                IVSSignature signatureState = ((IVSSignatureEntry)entryState).getSignatureState();
                IVSDigest digestState = (IVSDigest)signatureState.getDigestStates().get(0);
                return digestState.getChangeLevel();
            }
            if (entryState instanceof IVSTimestampEntry) {
                IVSDigest digestState = ((IVSTimestampEntry)entryState).getTimestampState().getDigestState();
                return digestState.getChangeLevel();
            }
            return -1;
        }

        @Override
        public String getClient() {
            return this.client;
        }

        @Override
        public PDDSS getDocumentDSS() {
            return null;
        }

        @Override
        public byte[] getDocumentHash() throws IOException, NoSuchAlgorithmException {
            return this.signatureDigest;
        }

        @Override
        public String getDocumentName() {
            return "adhoc.pdf";
        }

        @Override
        public MDPPermission getMdpPermission() {
            return null;
        }

        @Override
        public List<IRequestSignature> getSignatures() {
            return Collections.singletonList(new CmsRequestSignature());
        }

        private class CmsRequestSignature
        implements IRequestSignature {
            private CmsRequestSignature() {
            }

            @Override
            public boolean containsCrucialChanges() {
                return false;
            }

            @Override
            public boolean containsVisualChanges() {
                return false;
            }

            @Override
            public AdditionalInfosTO getAdditionalInfos() {
                return null;
            }

            @Override
            public SignatureTO.ChangeLevel getChangeLevel() {
                return null;
            }

            @Override
            public byte[] getSignatureContent() throws IOException {
                return CmsRequest.this.pkcs7.getEncoded();
            }

            @Override
            public Date getSignatureDate() {
                return new Date();
            }

            @Override
            public byte[] getSignatureDigest() {
                return CmsRequest.this.signatureDigest;
            }

            @Override
            public String getSignatureName() {
                return "adhocSignature";
            }

            @Override
            public boolean isTimestamp() {
                return false;
            }
        }
    }

    private static class LocatorRequest
    implements IRequest {
        private final String client;
        private final ILocator locator;
        private PDDocument document;
        private PDFSignatureContainer signatureContainer;
        private List<IRequestSignature> signatures;
        private IVSSignatureContainer validationState;

        public LocatorRequest(ILocator locator, String client) {
            this.locator = locator;
            this.client = client;
        }

        protected int getChangeLevel(IVSSignatureContainerEntry entryState) {
            if (entryState instanceof IVSSignatureEntry) {
                IVSSignature signatureState = ((IVSSignatureEntry)entryState).getSignatureState();
                IVSDigest digestState = (IVSDigest)signatureState.getDigestStates().get(0);
                return digestState.getChangeLevel();
            }
            if (entryState instanceof IVSTimestampEntry) {
                IVSDigest digestState = ((IVSTimestampEntry)entryState).getTimestampState().getDigestState();
                return digestState.getChangeLevel();
            }
            return -1;
        }

        @Override
        public String getClient() {
            return this.client;
        }

        protected PDDocument getDocument() throws IOException {
            if (this.document == null) {
                try {
                    this.document = PDDocument.createFromLocator((ILocator)this.locator);
                }
                catch (COSLoadException ex) {
                    throw new IOException(ex);
                }
            }
            return this.document;
        }

        @Override
        public PDDSS getDocumentDSS() throws IOException {
            return this.getDocument().getDSS();
        }

        @Override
        public byte[] getDocumentHash() throws IOException, NoSuchAlgorithmException {
            IDigester digester = DigestTools.createDigester((String)"SHA256");
            return digester.digest(LocatorTools.getBytes((ILocator)this.locator)).getBytes();
        }

        @Override
        public String getDocumentName() {
            return this.locator.getName();
        }

        @Override
        public MDPPermission getMdpPermission() {
            return this.signatureContainer.getPermissions();
        }

        protected PDFSignatureContainer getSignatureContainer() throws IOException {
            if (this.signatureContainer == null) {
                this.signatureContainer = PDFSignatureContainer.createSignatureContainer((PDDocument)this.getDocument());
            }
            return this.signatureContainer;
        }

        @Override
        public List<IRequestSignature> getSignatures() throws IOException {
            if (this.signatures == null) {
                this.signatures = this.getSignatureContainer().getEntries().stream().sorted((s1, s2) -> {
                    if (s1.getSignedRevision() == null || s2.getSignedRevision() == null) {
                        throw new IllegalStateException("PDF signature structure is corrupted or invalid: unable to determine signed revision");
                    }
                    long l1 = s1.getSignedRevision().getLength();
                    long l2 = s2.getSignedRevision().getLength();
                    return Long.compare(l1, l2);
                }).map(signatureEntry -> new LocatorRequestSignature((PDFSignatureContainerEntry)signatureEntry, this.getValidationState().getEntryState((ISignatureContainerEntry)signatureEntry))).collect(Collectors.toList());
            }
            return this.signatures;
        }

        protected IVSSignatureContainer getValidationState() {
            if (this.validationState == null) {
                IValidationContextFactory factory = ValidationEnvironment.get().getValidationContextFactory();
                IValidationContext validationContext = factory.createValidationContext(new ArgsBuilder().put("validateCertificates", (Object)false).put("validateTimestamps", (Object)false).put("applyCryptoConstraints", (Object)false).getArgs());
                ISignatureContainerValidator validator = validationContext.getSignatureContainerValidator();
                this.validationState = validator.validate((ISignatureContainer)this.signatureContainer, null, (IValidationParameters)new ValidationParameters());
            }
            return this.validationState;
        }

        private class LocatorRequestSignature
        implements IRequestSignature {
            private final PDSignature pdSignature;
            private final PDFSignatureContainerEntry signatureEntry;
            private final IVSSignatureContainerEntry validationState;

            public LocatorRequestSignature(PDFSignatureContainerEntry signatureEntry, IVSSignatureContainerEntry validationState) {
                this.signatureEntry = signatureEntry;
                this.pdSignature = signatureEntry.getPDSignature();
                this.validationState = validationState;
            }

            @Override
            public boolean containsCrucialChanges() {
                return this.validationState.getModificationState().containsCrucialChanges();
            }

            @Override
            public boolean containsVisualChanges() {
                return this.validationState.getModificationState().containsVisualChanges();
            }

            @Override
            public AdditionalInfosTO getAdditionalInfos() {
                IAdditionalInfoSet additionalInfoSet = (IAdditionalInfoSet)AdapterTools.getAdapter((Object)this.signatureEntry, IAdditionalInfoSet.class, null);
                if (additionalInfoSet == null) {
                    return null;
                }
                AdditionalInfosTO additionalInfos = new AdditionalInfosTO();
                additionalInfos.setReason(additionalInfoSet.getValue("Reason"));
                additionalInfos.setContactInfo(additionalInfoSet.getValue("ContactInfo"));
                additionalInfos.setLocation(additionalInfoSet.getValue("Location"));
                additionalInfos.setName(additionalInfoSet.getValue("Name"));
                return additionalInfos;
            }

            @Override
            public SignatureTO.ChangeLevel getChangeLevel() {
                int value = this.getChangeLevel(this.validationState);
                switch (value) {
                    case -1: {
                        return SignatureTO.ChangeLevel.UNDEFINED;
                    }
                    case 0: {
                        return SignatureTO.ChangeLevel.UNCHANGED;
                    }
                    case 1: {
                        return SignatureTO.ChangeLevel.IGNORABLE;
                    }
                    case 2: {
                        return SignatureTO.ChangeLevel.PERMITTED_BASIC;
                    }
                    case 3: {
                        return SignatureTO.ChangeLevel.PERMITTED_SIGN;
                    }
                    case 4: {
                        return SignatureTO.ChangeLevel.PERMITTED_FILL;
                    }
                    case 5: {
                        return SignatureTO.ChangeLevel.PERMITTED_ANNOTATE;
                    }
                    case 99: {
                        return SignatureTO.ChangeLevel.FORBIDDEN;
                    }
                }
                return SignatureTO.ChangeLevel.UNDEFINED;
            }

            protected int getChangeLevel(IVSSignatureContainerEntry entryState) {
                if (entryState instanceof IVSSignatureEntry) {
                    IVSSignature signatureState = ((IVSSignatureEntry)entryState).getSignatureState();
                    IVSDigest digestState = (IVSDigest)signatureState.getDigestStates().get(0);
                    return digestState.getChangeLevel();
                }
                if (entryState instanceof IVSTimestampEntry) {
                    IVSDigest digestState = ((IVSTimestampEntry)entryState).getTimestampState().getDigestState();
                    return digestState.getChangeLevel();
                }
                return -1;
            }

            @Override
            public byte[] getSignatureContent() {
                return this.pdSignature.getContentBytes();
            }

            @Override
            public Date getSignatureDate() {
                try {
                    CDSDate date = this.pdSignature.getDate();
                    if (date == null) {
                        return DateEnvironment.get().now();
                    }
                    return date.toDate();
                }
                catch (ParseException ex) {
                    Log.error(ex.getMessage(), (Throwable)ex);
                    return null;
                }
            }

            @Override
            public byte[] getSignatureDigest() throws IOException, NoSuchAlgorithmException {
                IDigest digest;
                AlgorithmSpec hashAlgorithmSpec = this.signatureEntry.getHashAlgorithmSpec();
                if (hashAlgorithmSpec == null) {
                    return null;
                }
                IDigester digester = DigestTools.createDigester((String)hashAlgorithmSpec.getAlgorithm().getCanonicalName());
                try (IRandomAccess randomAccess = LocatorRequest.this.locator.getRandomAccess();){
                    COSArray cosByteRange = this.pdSignature.cosGetByteRange();
                    if (cosByteRange == null) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    PDSignatureByteRange byteRangeStream = new PDSignatureByteRange(this.pdSignature.cosGetByteRange(), randomAccess);
                    digest = DigestTools.digest((IDigester)digester, (InputStream)byteRangeStream);
                }
                return digest.getBytes();
            }

            @Override
            public String getSignatureName() {
                return this.pdSignature.getAcroFormField().getQualifiedName();
            }

            @Override
            public boolean isTimestamp() {
                return this.signatureEntry instanceof PDFTimestampEntry;
            }
        }
    }

    private static interface IRequest {
        public String getClient();

        public PDDSS getDocumentDSS() throws IOException;

        public byte[] getDocumentHash() throws IOException, NoSuchAlgorithmException;

        public String getDocumentName();

        public MDPPermission getMdpPermission();

        public List<IRequestSignature> getSignatures() throws IOException;
    }

    private static interface IRequestSignature {
        public boolean containsCrucialChanges();

        public boolean containsVisualChanges();

        public AdditionalInfosTO getAdditionalInfos();

        public SignatureTO.ChangeLevel getChangeLevel();

        public byte[] getSignatureContent() throws IOException;

        public Date getSignatureDate();

        public byte[] getSignatureDigest() throws IOException, NoSuchAlgorithmException;

        public String getSignatureName();

        public boolean isTimestamp();
    }
}

