/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.NumericFormat;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class NumberFormat
extends NumericFormat {
    public static final String TYPE = "number";
    public static final String EXT_NUMBER_FORMAT = "EXTNumber_Format";
    public static final String EXT_NUMBER_KEYSTROKE = "EXTNumber_Keystroke";
    private int negativeFlags;
    private Object dummy;
    private String currencyTag = "";
    private boolean leading = false;

    public NumberFormat() {
    }

    public NumberFormat(int decimals, int separator, int negativeFlags, Object dummy, String currencyTag, boolean leading) {
        super(decimals, separator);
        this.setNegativeFlags(negativeFlags);
        this.setDummy(dummy);
        this.setCurrencyTag(currencyTag);
        this.setLeading(leading);
    }

    protected String createScript(String method, boolean appendScript) {
        String currency = this.getCurrencyTagEncoded();
        StringBuilder script = new StringBuilder();
        if (appendScript) {
            script.append(this.loadFunctionScript()).append(StringTools.LS);
        }
        script.append(method);
        script.append("(").append(this.getDecimals()).append(",").append(this.getSeparator()).append(",").append(this.getNegativeFlags()).append(",").append(0).append(",").append("\"").append(currency == null ? "" : currency).append("\"").append(",").append(this.isLeading()).append(");");
        return script.toString();
    }

    @Override
    protected void generateScripts() {
        if (this.getSeparator() > 3) {
            this.setFormatScript(this.createScript(EXT_NUMBER_FORMAT, true));
            this.setKeyStrokeScript(this.createScript(EXT_NUMBER_KEYSTROKE, true));
        } else {
            this.setFormatScript(this.createScript("AFNumber_Format", false));
            this.setKeyStrokeScript(this.createScript("AFNumber_Keystroke", false));
        }
    }

    public String getCurrencyTag() {
        return this.currencyTag;
    }

    public String getCurrencyTagEncoded() {
        if (this.getCurrencyTag() == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getCurrencyTag().length(); ++i) {
            char c = this.getCurrencyTag().charAt(i);
            buf.append("\\u");
            String hexString = Integer.toString(c, 16);
            for (int j = hexString.length(); j < 4; ++j) {
                buf.append('0');
            }
            buf.append(hexString);
        }
        return buf.toString();
    }

    public Object getDummy() {
        return this.dummy;
    }

    public int getNegativeFlags() {
        return this.negativeFlags;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isLeading() {
        return this.leading;
    }

    protected String loadFunctionScript() {
        InputStream is = this.getClass().getResourceAsStream("EXTNumberFormat.js");
        try {
            return StreamTools.getString((InputStream)is, (Charset)null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setCurrencyTag(String currencyTag) {
        this.currencyTag = currencyTag;
    }

    public void setDummy(Object dummy) {
        this.dummy = dummy;
    }

    public void setLeading(boolean leading) {
        this.leading = leading;
    }

    public void setNegativeFlags(int negativeFlags) {
        this.negativeFlags = negativeFlags;
    }
}

