/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.design.AbstractAnnotationDesigner;
import de.intarsys.pdf.design.tools.FormTools;
import de.intarsys.pdf.design.widget.PACKAGE;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.tools.message.IMessageBundle;

public class WidgetDesigner
extends AbstractAnnotationDesigner {
    private static IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public PDAnnotation addTransferable(PDAnnotation annotation, PDPage page) throws AnnotationDesignerException {
        String fieldName = (String)annotation.getAttribute((Object)"fieldName");
        COSObject cosFont = (COSObject)annotation.getAttribute((Object)"font");
        PDFont font = (PDFont)PDFont.META.createFromCos(cosFont.copyDeep());
        PDAcroForm form = page.getDoc().getAcroForm();
        if (form == null) {
            form = FormTools.createAcroForm(page.getDoc());
        }
        PDWidgetAnnotation widget = (PDWidgetAnnotation)super.addTransferable(annotation, page);
        PDAcroFormField field = widget.getAcroFormField();
        FormTools.addField(field, fieldName, form);
        field.setDefaultAppearanceFont(font);
        this.createAppearance((PDAnnotation)widget);
        return widget;
    }

    @Override
    protected void basicSetBorderColor(PDAnnotation annotation, float[] color) {
        PDAppearanceCharacteristics appChar = ((PDWidgetAnnotation)annotation).getAppearanceCharacteristics();
        if (appChar == null) {
            appChar = PDAppearanceCharacteristics.META.createNew();
            ((PDWidgetAnnotation)annotation).setAppearanceCharacteristics(appChar);
        }
        appChar.setBorderColor(color);
    }

    protected void basicSetFillColor(PDAnnotation annotation, float[] color) {
        PDAppearanceCharacteristics appChar = ((PDWidgetAnnotation)annotation).getAppearanceCharacteristics();
        if (appChar == null) {
            appChar = PDAppearanceCharacteristics.META.createNew();
            ((PDWidgetAnnotation)annotation).setAppearanceCharacteristics(appChar);
        }
        appChar.setBackgroundColor(color);
    }

    @Override
    public PDAnnotation createTransferable(PDAnnotation annotation) {
        PDAcroFormField field = ((PDWidgetAnnotation)annotation).getAcroFormField();
        PDWidgetAnnotation copy = (PDWidgetAnnotation)super.createTransferable(annotation);
        FormTools.fieldEntriesFill(field.getLogicalRoot().cosGetDict(), copy.getAcroFormField().cosGetDict());
        copy.cosRemoveField(PDAcroFormField.DK_Parent);
        copy.cosRemoveField(PDAnnotation.DK_P);
        copy.cosRemoveField(PDAcroFormField.DK_T);
        PDAppearanceTools.resetAppearance((COSDictionary)copy.cosGetField(PDAnnotation.DK_AP).asDictionary());
        copy.setAttribute((Object)"font", (Object)field.getDefaultAppearanceFont().cosGetObject().copyDeep());
        copy.setAttribute((Object)"fieldName", (Object)field.getQualifiedName());
        return copy;
    }

    @Override
    public void deleteAnnotation(PDAnnotation annotation) {
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAcroFormField root = widget.getAcroFormField().getLogicalRoot();
        if (root.cosGetObject() == widget.getAcroFormField().cosGetObject()) {
            FormTools.calculationOrderRemove(root.getAcroForm(), root);
        }
        super.deleteAnnotation(annotation);
        FormTools.cleanFieldHierarchy(root);
    }

    @Override
    public String getAnnotationLabel(PDAnnotation annotation) {
        PDAcroFormField field = ((PDWidgetAnnotation)annotation).getAcroFormField();
        if (field.isTypeBtn()) {
            PDAFButtonField button = (PDAFButtonField)field;
            if (button.isPushbutton()) {
                return Msg.getString("WidgetDesigner.AnnotationLabelPushbutton", new Object[]{field.getQualifiedName()});
            }
            if (button.isRadio()) {
                return Msg.getString("WidgetDesigner.AnnotationLabelRadio", new Object[]{field.getQualifiedName()});
            }
            if (button.isCheckbox()) {
                return Msg.getString("WidgetDesigner.AnnotationLabelCheckbox", new Object[]{field.getQualifiedName()});
            }
        } else {
            if (field.isTypeCh()) {
                PDAFChoiceField choice = (PDAFChoiceField)field;
                if (choice.isCombo()) {
                    return Msg.getString("WidgetDesigner.AnnotationLabelCombo", new Object[]{field.getQualifiedName()});
                }
                return Msg.getString("WidgetDesigner.AnnotationLabelList", new Object[]{field.getQualifiedName()});
            }
            if (field.isTypeTx()) {
                return Msg.getString("WidgetDesigner.AnnotationLabelText", new Object[]{field.getQualifiedName()});
            }
            if (field.isTypeSig()) {
                return Msg.getString("WidgetDesigner.AnnotationLabelSignature", new Object[]{field.getQualifiedName()});
            }
        }
        return Msg.getString("WidgetDesigner.AnnotationLabel", new Object[]{field.getQualifiedName()});
    }

    @Override
    public COSName getAnnotationType() {
        return PDWidgetAnnotation.CN_Subtype_Widget;
    }

    @Override
    public float[] getBorderColor(PDAnnotation annotation) {
        PDAppearanceCharacteristics appChar = ((PDWidgetAnnotation)annotation).getAppearanceCharacteristics();
        return appChar == null ? null : PDFColorTools.fixColorValues((float[])appChar.getBorderColor());
    }

    @Override
    public float[] getFillColor(PDAnnotation annotation) {
        PDAppearanceCharacteristics appChar = ((PDWidgetAnnotation)annotation).getAppearanceCharacteristics();
        return appChar == null ? null : PDFColorTools.fixColorValues((float[])appChar.getBackgroundColor());
    }

    @Override
    protected void rotateTransferable(PDAnnotation annotation, int rotate) {
        super.rotateTransferable(annotation, rotate);
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
            widget.setAppearanceCharacteristics(apc);
        }
        apc.setRotation(apc.getRotation() + rotate);
    }

    @Override
    public void setFillColor(PDAnnotation annotation, float[] color) {
        this.basicSetFillColor(annotation, color);
        this.createAppearance(annotation);
    }

    @Override
    public boolean supports(PDDocument doc) {
        return doc.getAccessPermissions().mayModifyAnnotation() && doc.getAccessPermissions().mayModify();
    }

    @Override
    public boolean supportsBorderColor() {
        return true;
    }

    @Override
    public boolean supportsFillColor() {
        return true;
    }

    @Override
    protected void unrotateTransferable(PDAnnotation annotation, int rotate) {
        super.unrotateTransferable(annotation, rotate);
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAppearanceCharacteristics apc = widget.getAppearanceCharacteristics();
        if (apc == null) {
            apc = PDAppearanceCharacteristics.META.createNew();
            widget.setAppearanceCharacteristics(apc);
        }
        apc.setRotation(apc.getRotation() - rotate);
    }
}

