/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.design.widget.AnnotationApplication;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class TemplateApplication
extends AnnotationApplication {
    public static final String APPLICATION_TYPE = "template";
    private double deltaX;
    private double deltaY;
    private boolean primaryX = true;

    public static TemplateApplication createFromArgs(IArgs args) {
        TemplateApplication result = new TemplateApplication();
        result.setDeltaX(ArgTools.getFloatStrict((IArgs)args, (String)"deltaX", (float)0.0f));
        result.setDeltaY(ArgTools.getFloatStrict((IArgs)args, (String)"deltaY", (float)0.0f));
        result.setPrimaryX(ArgTools.getBool((IArgs)args, (String)"primaryX", (boolean)true));
        if (Math.abs(result.getDeltaX()) < 1.0 && Math.abs(result.getDeltaY()) < 1.0) {
            throw ExceptionTools.argumentInvalid((String)"deltaX, deltaY", (String)"at least one delta must be > 1", null);
        }
        return result;
    }

    protected boolean accept(PDAnnotation annot) {
        return annot.isWidgetAnnotation();
    }

    @Override
    public String createFieldName(AnnotationDefinition annotationDefinition) {
        String definitionName = annotationDefinition.getFieldDefinition().getFieldName();
        if (StringTools.isEmpty((String)definitionName)) {
            return null;
        }
        PDAcroForm form = annotationDefinition.getDocument().getAcroForm();
        return this.getNextFieldName(form, definitionName);
    }

    @Override
    public Rectangle2D createRect(AnnotationDefinition annotationDefinition, PDPage page) {
        Rectangle2D newRect = this.createRect(annotationDefinition);
        this.alignPage(annotationDefinition, page, newRect);
        return this.detectCollision(annotationDefinition, page, newRect);
    }

    protected Rectangle2D detectCollision(AnnotationDefinition annotationDefinition, PDPage page, Rectangle2D startRect) {
        Rectangle2D currentRect = (Rectangle2D)startRect.clone();
        List annots = page.getAnnotations();
        if (annots == null) {
            return currentRect;
        }
        while (true) {
            if (!this.detectCollision(annots, currentRect)) {
                return currentRect;
            }
            if (this.shiftPrimary(startRect, currentRect) && !this.outOfPageScope(page, currentRect)) continue;
            this.resetPrimary(startRect, currentRect);
            if (!this.shiftSecondary(startRect, currentRect) || this.outOfPageScope(page, currentRect)) break;
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    protected boolean detectCollision(List<PDAnnotation> annots, Rectangle2D newRect) {
        for (PDAnnotation annot : annots) {
            if (!this.accept(annot) || !this.detectCollision(annot, newRect)) continue;
            return true;
        }
        return false;
    }

    protected boolean detectCollision(PDAnnotation annot, Rectangle2D newRect) {
        return annot.getRectangle().toRectangle().intersects(newRect);
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public boolean isPrimaryX() {
        return this.primaryX;
    }

    protected boolean outOfPageScope(PDPage page, Rectangle2D currentRect) {
        Rectangle2D pageRect = page.getCropBox().toNormalizedRectangle();
        return !pageRect.contains(currentRect);
    }

    protected void resetPrimary(Rectangle2D startRect, Rectangle2D currentRect) {
        if (this.isPrimaryX()) {
            currentRect.setRect(startRect.getX(), currentRect.getY(), currentRect.getWidth(), currentRect.getHeight());
        } else {
            currentRect.setRect(currentRect.getX(), startRect.getY(), currentRect.getWidth(), currentRect.getHeight());
        }
    }

    public void setDeltaX(double deltaX) {
        this.deltaX = deltaX;
    }

    public void setDeltaY(double deltaY) {
        this.deltaY = deltaY;
    }

    public void setPrimaryX(boolean primaryX) {
        this.primaryX = primaryX;
    }

    protected boolean shiftPrimary(Rectangle2D startRect, Rectangle2D currentRect) {
        if (this.isPrimaryX()) {
            if (this.getDeltaX() > -1.0 && this.getDeltaX() < 1.0) {
                return false;
            }
            currentRect.setRect(currentRect.getX() + this.getDeltaX(), currentRect.getY(), currentRect.getWidth(), currentRect.getHeight());
        } else {
            if (this.getDeltaY() > -1.0 && this.getDeltaY() < 1.0) {
                return false;
            }
            currentRect.setRect(currentRect.getX(), currentRect.getY() + this.getDeltaY(), currentRect.getWidth(), currentRect.getHeight());
        }
        return true;
    }

    protected boolean shiftSecondary(Rectangle2D startRect, Rectangle2D currentRect) {
        if (this.isPrimaryX()) {
            if (this.getDeltaY() > -1.0 && this.getDeltaY() < 1.0) {
                return false;
            }
            currentRect.setRect(currentRect.getX(), currentRect.getY() + this.getDeltaY(), currentRect.getWidth(), currentRect.getHeight());
        } else {
            if (this.getDeltaX() > -1.0 && this.getDeltaX() < 1.0) {
                return false;
            }
            currentRect.setRect(currentRect.getX() + this.getDeltaX(), currentRect.getY(), currentRect.getWidth(), currentRect.getHeight());
        }
        return true;
    }
}

