/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetFactory;
import de.intarsys.pdf.app.appearance.common.FontInfo;
import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.app.page.StaticSinglePageSelector;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.design.widget.CommonFieldReference;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.design.widget.PACKAGE;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;

@Deprecated
public class NewFieldReference
extends CommonFieldReference {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private Rectangle2D rectScaled;
    private boolean adjustForRotate = false;
    private FontInfo fontInfo = new FontInfo();
    private EnumAlignment hAlign = EnumAlignment.START;
    private EnumAlignment vAlign = EnumAlignment.START;
    private PageSelector pageSelector;
    private String fieldType;

    protected NewFieldReference(NewFieldReference ref, PDDocument doc) {
        super(ref, doc);
        this.rectScaled = ref.rectScaled;
        this.pageSelector = ref.pageSelector;
        this.fieldType = ref.fieldType;
        this.vAlign = ref.vAlign;
        this.hAlign = ref.hAlign;
    }

    public NewFieldReference(PDDocument doc, String fieldType) {
        this(doc, fieldType, new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f), 0);
        this.setVisible(false);
    }

    public NewFieldReference(PDDocument doc, String fieldType, Rectangle2D rect, int pageIndex) {
        super(doc);
        this.setFieldType(fieldType);
        this.setRectScaled(rect);
        this.setPageSelector(new StaticSinglePageSelector(pageIndex));
    }

    @Override
    protected PDAcroFormField createField() {
        if (this.detectField() != null) {
            String fieldName = WidgetFactory.getFieldName(this.getAttributes());
            throw new IllegalArgumentException("field '" + fieldName + "' already present");
        }
        if (this.getDocument() == null) {
            return null;
        }
        PDAcroFormField result = null;
        PageSelector tempSelector = this.getPageSelector();
        if (tempSelector == null) {
            tempSelector = new StaticSinglePageSelector(0);
        }
        Iterator<PDPage> it = tempSelector.getPages(this.getDocument());
        while (it.hasNext()) {
            PDPage page = it.next();
            result = this.createField(page);
            if (WidgetFactory.getFieldName(this.getAttributes()) != null) continue;
            WidgetFactory.setFieldName(this.getAttributes(), result.getLocalName());
        }
        if (result == null) {
            return null;
        }
        return result.getLogicalRoot();
    }

    protected PDAcroFormField createField(PDPage page) {
        Map attributes = this.getAttributes();
        IAnnotationFactory factory = AnnotationOutlet.get().lookupAnnotationFactory(PDWidgetAnnotation.CN_Subtype_Widget);
        if ("Sig".equals(this.getFieldType())) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Sig);
            AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
            attributes.put(PDAcroFormField.DK_Ff, flags);
            try {
                PDAnnotation annot = factory.createAnnotation(page, this.repositionRect(page), attributes);
                PDAcroFormField acroFormField = ((PDWidgetAnnotation)annot).getAcroFormField();
                this.getFontInfo().initField(acroFormField);
                return acroFormField;
            }
            catch (ObjectCreationException e) {
                throw new COSRuntimeException((Throwable)e);
            }
        }
        if ("Tx".equals(this.getFieldType())) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
            AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
            flags.setEdit(true);
            attributes.put(PDAcroFormField.DK_Ff, flags);
            try {
                PDAnnotation annot = factory.createAnnotation(page, this.repositionRect(page), attributes);
                return ((PDWidgetAnnotation)annot).getAcroFormField();
            }
            catch (ObjectCreationException e) {
                throw new COSRuntimeException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("field type '" + this.getFieldType() + "' not supported");
    }

    @Override
    public IFieldReference createInContext(PDDocument doc) {
        if (doc == this.getDocument()) {
            return this;
        }
        return new NewFieldReference(this, doc);
    }

    protected Rectangle2D createRect() {
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        Point2D tempPoint = this.getPosition();
        if (tempPoint != null) {
            x = (float)tempPoint.getX();
            y = (float)tempPoint.getY();
        }
        if ((tempPoint = this.getSize()) != null) {
            w = (float)tempPoint.getX();
            h = (float)tempPoint.getY();
        }
        return new Rectangle2D.Float(x, y, w, h);
    }

    protected Rectangle2D createRectScaled() {
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        if (this.getPositionScaled() != null) {
            x = (float)this.getPositionScaled().getX();
            y = (float)this.getPositionScaled().getY();
        }
        if (this.getSizeScaled() != null) {
            w = (float)this.getSizeScaled().getX();
            h = (float)this.getSizeScaled().getY();
        }
        return new Rectangle2D.Float(x, y, w, h);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof NewFieldReference) {
            NewFieldReference otherRef = (NewFieldReference)obj;
            if (!LangTools.equals((Object)this.getPageSelector(), (Object)otherRef.getPageSelector())) {
                return false;
            }
            return LangTools.equals((Object)this.getRectScaled(), (Object)otherRef.getRectScaled());
        }
        return false;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public EnumAlignment getHAlign() {
        return this.hAlign;
    }

    @Override
    public String getLabel() {
        if (this.isVisible()) {
            return Msg.getString("NewFieldReference.labelVisible", new Object[0]);
        }
        return Msg.getString("NewFieldReference.labelInvisible", new Object[0]);
    }

    public PageSelector getPageSelector() {
        return this.pageSelector;
    }

    public Rectangle2D getRect() {
        return this.createRect();
    }

    public Rectangle2D getRectScaled() {
        if (this.rectScaled == null) {
            this.rectScaled = this.createRectScaled();
        }
        return this.rectScaled;
    }

    public EnumAlignment getVAlign() {
        return this.vAlign;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAdjustForRotate() {
        return this.adjustForRotate;
    }

    public boolean isNew() {
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setField(null);
        this.setAnnotation(null);
    }

    protected Rectangle2D repositionRect(PDPage page) {
        Rectangle2D newRect = this.getRect();
        double x = newRect.getX();
        double y = newRect.getY();
        double w = newRect.getWidth();
        double h = newRect.getHeight();
        Rectangle2D pageRect = page.getCropBox().toRectangle();
        AffineTransform transform = null;
        if (this.isAdjustForRotate()) {
            transform = PDFGeometryTools.createPageSpace((PDPage)page);
            pageRect = transform.createTransformedShape(pageRect).getBounds2D();
        }
        double urx = pageRect.getMaxX();
        double ury = pageRect.getMaxY();
        double www = pageRect.getWidth();
        double hhh = pageRect.getHeight();
        if (this.hAlign.equals((Object)EnumAlignment.START)) {
            // empty if block
        }
        if (this.hAlign.equals((Object)EnumAlignment.END)) {
            x = urx - x - w;
        }
        if (this.hAlign.equals((Object)EnumAlignment.CENTER)) {
            x = www / 2.0 - w / 2.0 + x;
        }
        if (this.vAlign.equals((Object)EnumAlignment.START)) {
            // empty if block
        }
        if (this.vAlign.equals((Object)EnumAlignment.END)) {
            y = ury - y - h;
        }
        if (this.vAlign.equals((Object)EnumAlignment.CENTER)) {
            y = hhh / 2.0 - h / 2.0 + y;
        }
        if (transform != null) {
            try {
                AffineTransform inverse = transform.createInverse();
                double[] points = new double[]{x, y, x + w, y + h};
                inverse.transform(points, 0, points, 0, 2);
                newRect.setFrameFromDiagonal(points[0], points[1], points[2], points[3]);
            }
            catch (NoninvertibleTransformException e) {
                throw new UnreachableCodeError();
            }
        } else {
            newRect.setRect(x, y, w, h);
        }
        return newRect;
    }

    public void setAdjustForRotate(boolean adjustForRotate) {
        this.adjustForRotate = adjustForRotate;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setHAlign(EnumAlignment align) {
        this.hAlign = align;
    }

    public void setPageSelector(PageSelector pageSelector) {
        this.pageSelector = pageSelector;
    }

    @Override
    public void setPositionScaled(Point2D position) {
        super.setPositionScaled(position);
        this.rectScaled = this.createRectScaled();
    }

    public void setRectScaled(Rectangle2D rect) {
        this.setPositionScaled(new Point2D.Double(rect.getMinX(), rect.getMinY()));
        this.setSizeScaled(new Point2D.Double(rect.getWidth(), rect.getHeight()));
    }

    @Override
    public void setSizeScaled(Point2D size) {
        super.setSizeScaled(size);
        this.rectScaled = this.createRectScaled();
    }

    public void setVAlign(EnumAlignment align) {
        this.vAlign = align;
    }
}

