/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.EnumeratedApplication;
import de.intarsys.pdf.design.widget.PlainApplication;
import de.intarsys.pdf.design.widget.TemplateApplication;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AnnotationApplication {
    public static final String ARG_TYPE = "type";

    public static AnnotationApplication createFromArgs(IArgs args) {
        String type = ArgTools.getString((IArgs)args, (String)ARG_TYPE, null);
        if (LangTools.equals((Object)type, (Object)"template")) {
            return TemplateApplication.createFromArgs(args);
        }
        if (LangTools.equals((Object)type, (Object)"enumerated")) {
            return EnumeratedApplication.createFromArgs(args);
        }
        if (LangTools.equals((Object)type, (Object)"plain")) {
            return new PlainApplication();
        }
        if (StringTools.isEmpty((String)type)) {
            return new PlainApplication();
        }
        throw new IllegalArgumentException("annotation application type '" + type + "' not supported");
    }

    protected void alignPage(AnnotationDefinition annotationDefinition, PDPage page, Rectangle2D rect) throws UnreachableCodeError {
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        Rectangle2D pageRect = page.getCropBox().toRectangle();
        AffineTransform transform = null;
        if (annotationDefinition.isAdjustForRotate()) {
            transform = PDFGeometryTools.createPageSpace((PDPage)page);
            pageRect = transform.createTransformedShape(pageRect).getBounds2D();
        }
        double urx = pageRect.getMaxX();
        double ury = pageRect.getMaxY();
        double www = pageRect.getWidth();
        double hhh = pageRect.getHeight();
        if (!annotationDefinition.getHAlign().equals((Object)EnumAlignment.START)) {
            if (annotationDefinition.getHAlign().equals((Object)EnumAlignment.END)) {
                x = urx - x - w;
            } else if (annotationDefinition.getHAlign().equals((Object)EnumAlignment.CENTER)) {
                x = www / 2.0 - w / 2.0 + x;
            }
        }
        if (!annotationDefinition.getVAlign().equals((Object)EnumAlignment.START)) {
            if (annotationDefinition.getVAlign().equals((Object)EnumAlignment.END)) {
                y = ury - y - h;
            } else if (annotationDefinition.getVAlign().equals((Object)EnumAlignment.CENTER)) {
                y = hhh / 2.0 - h / 2.0 + y;
            }
        }
        if (transform != null) {
            try {
                AffineTransform inverse = transform.createInverse();
                double[] points = new double[]{x, y, x + w, y + h};
                inverse.transform(points, 0, points, 0, 2);
                rect.setFrameFromDiagonal(points[0], points[1], points[2], points[3]);
            }
            catch (NoninvertibleTransformException e) {
                throw new UnreachableCodeError();
            }
        } else {
            rect.setRect(x, y, w, h);
        }
    }

    public abstract String createFieldName(AnnotationDefinition var1);

    public Rectangle2D createRect(AnnotationDefinition annotationDefinition) {
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        Point2D tempPoint = annotationDefinition.getPosition();
        if (tempPoint != null) {
            x = (float)tempPoint.getX();
            y = (float)tempPoint.getY();
        }
        if ((tempPoint = annotationDefinition.getSize()) != null) {
            w = (float)tempPoint.getX();
            h = (float)tempPoint.getY();
        }
        return new Rectangle2D.Float(x, y, w, h);
    }

    public abstract Rectangle2D createRect(AnnotationDefinition var1, PDPage var2);

    protected String getNextFieldName(PDAcroForm form, String fieldName) {
        if (form == null) {
            return fieldName + "1";
        }
        int i = 1;
        while (form.getField(fieldName + i) != null) {
            ++i;
        }
        return fieldName + i;
    }
}

