/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.tools;

import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.design.tools.PACKAGE;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAFIntermediateNode;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FormTools {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private static final byte[] DEFAULT_APPEARANCE_STRING = "/Helv 0 Tf 0 g".getBytes();
    private static final COSName FONT_NAME = COSName.constant((String)"Helv");

    protected static void addChildToField(PDAcroFormField field, PDAcroFormField child, Map copied) throws AnnotationDesignerException {
        if (field instanceof PDAFIntermediateNode || !FormTools.areTypesCompatible(field, child)) {
            throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidType", new Object[0]));
        }
        PDAcroFormField newParent = field;
        if (newParent.isAnnotation()) {
            newParent = FormTools.createLogicalField(newParent, copied);
            FormTools.calculationOrderReplace(field.getAcroForm(), field, newParent);
        }
        FormTools.fieldEntriesRemove(child.cosGetDict());
        newParent.addField(child);
    }

    public static void addField(PDAcroFormField field, String newName, PDAcroForm form) throws AnnotationDesignerException {
        FormTools.addField(field, newName, form, new HashMap());
    }

    public static void addField(PDAcroFormField field, String newName, PDAcroForm form, Map copied) throws AnnotationDesignerException {
        PDAcroFormField targetField = form.getField(newName);
        if (targetField == null) {
            FormTools.buildNodeTree(field, newName, form);
        } else {
            COSObject targetFieldValue;
            boolean valueChanged = false;
            COSObject fieldValue = field.cosGetValue();
            valueChanged = !fieldValue.equals(targetFieldValue = targetField.cosGetValue());
            FormTools.addChildToField(targetField, field, copied);
            if (valueChanged) {
                PDAcroFormField newRoot = targetField.getLogicalRoot();
                COSObject value = newRoot.cosGetValue();
                newRoot.cosSetValue(value.copyOptional());
                AppearanceCreatorTools.createAppearance((PDAcroFormField)newRoot);
            }
        }
    }

    protected static boolean areTypesCompatible(PDAcroFormField fieldA, PDAcroFormField fieldB) {
        COSName typeA = fieldA.cosGetFieldType();
        COSName typeB = fieldB.cosGetFieldType();
        if (typeA == null || typeB == null || !typeA.equals((Object)typeB)) {
            return false;
        }
        if (fieldA.isTypeBtn()) {
            if (fieldA.getFieldFlags().isRadio()) {
                return fieldB.getFieldFlags().isRadio();
            }
            if (fieldA.getFieldFlags().isPushbutton()) {
                return fieldB.getFieldFlags().isPushbutton();
            }
            return !fieldB.getFieldFlags().isRadio() && !fieldB.getFieldFlags().isPushbutton();
        }
        if (fieldA.isTypeCh()) {
            if (fieldA.getFieldFlags().isCombo()) {
                return fieldB.getFieldFlags().isCombo();
            }
            return !fieldB.getFieldFlags().isCombo();
        }
        return true;
    }

    protected static void buildNodeTree(PDAcroFormField field, String path, PDAcroForm form) throws AnnotationDesignerException {
        ArrayList<String> remainingPath = new ArrayList<String>();
        PDAcroFormField parent = null;
        StringTokenizer t = new StringTokenizer(path, ".");
        while (t.hasMoreTokens()) {
            String part = t.nextToken();
            PDAcroFormField ancestor = null;
            ancestor = parent == null ? form.getField(part) : parent.getField(part);
            if (ancestor == null) {
                remainingPath.add(part);
                while (t.hasMoreTokens()) {
                    remainingPath.add(t.nextToken());
                }
                continue;
            }
            parent = ancestor;
        }
        if (parent != null && !(parent instanceof PDAFIntermediateNode)) {
            throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidHierarchy", new Object[0]));
        }
        PDAcroFormField root = null;
        PDAcroFormField currentParent = null;
        Iterator i = remainingPath.iterator();
        while (i.hasNext()) {
            String part = (String)i.next();
            Object current = null;
            current = i.hasNext() ? (PDAFIntermediateNode)PDAFIntermediateNode.META.createNew() : field;
            current.setLocalName(part);
            if (root == null) {
                root = current;
                currentParent = current;
                continue;
            }
            currentParent.addField(current);
            currentParent = current;
        }
        if (parent == null) {
            form.addField(root);
        } else {
            parent.addField(root);
        }
        FormTools.calculationOrderAdd(form, field);
    }

    public static void calculationOrderAdd(PDAcroForm form, PDAcroFormField field) {
        PDAdditionalActions aa = field.getAdditionalActions();
        if (aa == null) {
            return;
        }
        if (aa.getAction(PDAdditionalActions.CN_trigger_C) == null) {
            return;
        }
        COSObject cosField = field.cosGetObject();
        COSArray co = form.cosGetField(PDAcroForm.DK_CO).asArray();
        if (co == null) {
            co = COSArray.create();
            form.cosSetField(PDAcroForm.DK_CO, (COSObject)co);
        }
        if (co.indexOf(cosField) < 0) {
            co.add(cosField);
        }
    }

    public static void calculationOrderRemove(PDAcroForm form, PDAcroFormField field) {
        COSObject cosField = field.cosGetObject();
        COSArray co = form.cosGetField(PDAcroForm.DK_CO).asArray();
        if (co == null) {
            return;
        }
        int index = co.indexOf(cosField);
        if (index > -1) {
            co.remove(cosField);
        }
        if (co.size() == 0) {
            form.cosRemoveField(PDAcroForm.DK_CO);
        }
    }

    protected static void calculationOrderReplace(PDAcroForm form, PDAcroFormField oldField, PDAcroFormField newField) {
        COSObject cosOldField = oldField.cosGetObject();
        COSObject cosNewField = newField.cosGetObject();
        COSArray co = form.cosGetField(PDAcroForm.DK_CO).asArray();
        if (co == null) {
            return;
        }
        int index = co.indexOf(cosOldField);
        if (index > -1) {
            co.set(index, cosNewField);
        }
    }

    protected static void checkNameConstraints(PDAcroFormField field, PDAcroForm form, String newName) throws AnnotationDesignerException {
        if (newName == null || newName.length() == 0) {
            throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorEmptyName", new Object[0]));
        }
        PDAcroFormField partner = form.getField(newName);
        if (partner == null) {
            String componentName;
            PDAcroForm component = form;
            StringTokenizer t = new StringTokenizer(newName, ".");
            while (t.hasMoreTokens() && (component = component.getField(componentName = t.nextToken())) != null) {
                if (component == field) {
                    if (field.getLogicalRoot().getGenericChildren().size() > 1) {
                        throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidHierarchy", new Object[0]));
                    }
                    break;
                }
                if (component instanceof PDAFIntermediateNode) continue;
                throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidHierarchy", new Object[0]));
            }
        } else if (partner instanceof PDAFIntermediateNode) {
            boolean willBeRemoved = false;
            for (PDAcroFormField current = field.getParent(); current != null; current = current.getParent()) {
                if (current != partner) continue;
                if (current.getGenericChildren().size() >= 2) break;
                willBeRemoved = true;
                break;
            }
            if (!willBeRemoved) {
                throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidType", new Object[0]));
            }
        } else if (!FormTools.areTypesCompatible(partner, field)) {
            throw new AnnotationDesignerException(Msg.getString("FormTools.ErrorInvalidType", new Object[0]));
        }
    }

    public static PDAcroFormField cleanFieldHierarchy(PDAcroFormField field) {
        PDAcroForm form = field.getAcroForm();
        if (form == null || form.getField(field.getQualifiedName()) == null || field.isAnnotation()) {
            return field;
        }
        List kids = field.getKids();
        if (kids == null || kids.size() != 1) {
            return field;
        }
        PDAcroFormField kid = (PDAcroFormField)kids.get(0);
        if (!kid.isAnnotation()) {
            return field;
        }
        PDAcroFormNode parent = (PDAcroFormNode)field.getGenericParent();
        field.dispose(false);
        kid.dispose(false);
        field.cosRemoveField(PDAcroFormField.DK_Kids);
        COSDictionary fieldDict = field.cosGetDict();
        COSDictionary kidDict = kid.cosGetDict();
        for (COSName key : new ArrayList(fieldDict.keySet())) {
            COSObject value = fieldDict.remove(key);
            kidDict.put(key, value);
        }
        if (parent != null) {
            parent.addField(kid);
        }
        FormTools.calculationOrderReplace(form, field, kid);
        return kid;
    }

    public static PDAcroForm createAcroForm(PDDocument doc) {
        if (doc.getAcroForm() != null) {
            return doc.getAcroForm();
        }
        PDAcroForm form = doc.createAcroForm();
        PDResources resources = form.getDefaultResources();
        PDFont font = resources.getFontResource(FONT_NAME);
        if (font == null) {
            font = PDFontTools.createBuiltinFont((String)"Helvetica");
            resources.addFontResource(FONT_NAME, font);
        }
        CSContent app = CSContent.createFromBytes((byte[])DEFAULT_APPEARANCE_STRING);
        form.setDefaultAppearanceContent(app);
        return form;
    }

    protected static PDAcroFormField createLogicalField(PDAcroFormField field, Map copied) {
        PDAcroForm form = field.getAcroForm();
        PDAcroFormField parent = field.getParent();
        if (parent == null) {
            form.removeField(field);
        } else {
            parent.removeField(field);
        }
        COSDictionary annotDict = field.cosGetDict();
        COSDictionary fieldDict = COSDictionary.create();
        FormTools.fieldEntriesMove(annotDict, fieldDict, copied);
        fieldDict.beIndirect();
        PDAcroFormField logicalField = (PDAcroFormField)PDAcroFormField.META.createFromCos((COSObject)fieldDict);
        PDAcroFormField annotField = (PDAcroFormField)PDAcroFormField.META.createFromCos((COSObject)annotDict);
        logicalField.addField(annotField);
        if (parent == null) {
            form.addField(logicalField);
        } else {
            parent.addField(logicalField);
        }
        return logicalField;
    }

    protected static void entriesFill(COSDictionary source, COSDictionary target, Map copied) {
        for (COSName key : source.keySet()) {
            if (target.containsKey(key)) continue;
            COSObject value = source.get(key).copyDeep(copied);
            target.put(key, value);
        }
    }

    public static void fieldEntriesFill(COSDictionary source, COSDictionary target) {
        FormTools.fieldEntriesFill(source, target, new HashMap());
    }

    public static void fieldEntriesFill(COSDictionary source, COSDictionary target, Map copied) {
        ArrayList<COSName> fieldEntries = new ArrayList<COSName>();
        for (COSName key : source.keySet()) {
            if (!FormTools.isFieldEntry(key)) continue;
            fieldEntries.add(key);
        }
        for (COSName key : fieldEntries) {
            if (target.containsKey(key)) {
                COSDictionary targetDict;
                COSDictionary sourceDict;
                if (!key.equals((Object)IAdditionalActionSupport.DK_AA) || (sourceDict = source.get(key).asDictionary()) == null) continue;
                COSObject targetObj = target.get(key);
                if (targetObj.isNull()) {
                    targetObj = COSDictionary.create();
                    target.put(key, targetObj);
                }
                if ((targetDict = targetObj.asDictionary()) == null) continue;
                FormTools.entriesFill(sourceDict, targetDict, copied);
                continue;
            }
            COSObject value = source.get(key).copyDeep(copied);
            target.put(key, value);
        }
    }

    protected static void fieldEntriesMove(COSDictionary source, COSDictionary target, Map copied) {
        ArrayList<COSName> fieldEntries = new ArrayList<COSName>();
        for (COSName key : source.keySet()) {
            if (!FormTools.isFieldEntry(key)) continue;
            fieldEntries.add(key);
        }
        for (COSName key : fieldEntries) {
            if (target.containsKey(key)) continue;
            FormTools.fieldEntryMove(key, source, target, copied);
        }
    }

    protected static void fieldEntriesRemove(COSDictionary dict) {
        ArrayList<COSName> fieldEntries = new ArrayList<COSName>();
        for (COSName key : dict.keySet()) {
            if (!FormTools.isFieldEntry(key)) continue;
            fieldEntries.add(key);
        }
        for (COSName key : fieldEntries) {
            FormTools.fieldEntryRemove(key, dict);
        }
    }

    protected static void fieldEntryMove(COSName key, COSDictionary source, COSDictionary target, Map copied) {
        if (IAdditionalActionSupport.DK_AA.equals((Object)key)) {
            COSDictionary sourceAA = source.get(key).asDictionary();
            COSDictionary targetAA = sourceAA.copyDeep(copied).asDictionary();
            sourceAA.remove(PDAdditionalActions.CN_trigger_K);
            sourceAA.remove(PDAdditionalActions.CN_trigger_V);
            sourceAA.remove(PDAdditionalActions.CN_trigger_C);
            sourceAA.remove(PDAdditionalActions.CN_trigger_F);
            targetAA.remove(PDAdditionalActions.CN_trigger_U);
            targetAA.remove(PDAdditionalActions.CN_trigger_D);
            targetAA.remove(PDAdditionalActions.CN_trigger_E);
            targetAA.remove(PDAdditionalActions.CN_trigger_X);
            targetAA.remove(PDAdditionalActions.CN_trigger_Fo);
            targetAA.remove(PDAdditionalActions.CN_trigger_Bl);
            targetAA.remove(PDAdditionalActions.CN_trigger_PO);
            targetAA.remove(PDAdditionalActions.CN_trigger_PC);
            targetAA.remove(PDAdditionalActions.CN_trigger_PV);
            targetAA.remove(PDAdditionalActions.CN_trigger_PI);
            if (sourceAA.size() == 0) {
                source.remove(key);
            }
            if (targetAA.size() != 0) {
                target.put(key, (COSObject)targetAA);
            }
        } else {
            COSObject value = source.get(key).copyDeep(copied);
            source.remove(key);
            target.put(key, value);
        }
    }

    protected static void fieldEntryRemove(COSName key, COSDictionary dict) {
        if (IAdditionalActionSupport.DK_AA.equals((Object)key)) {
            COSDictionary aa = dict.get(key).asDictionary();
            aa.remove(PDAdditionalActions.CN_trigger_K);
            aa.remove(PDAdditionalActions.CN_trigger_V);
            aa.remove(PDAdditionalActions.CN_trigger_C);
            aa.remove(PDAdditionalActions.CN_trigger_F);
        } else {
            dict.remove(key);
        }
    }

    public static PDWidgetAnnotation importWidget(PDWidgetAnnotation widget, PDAcroForm form) throws AnnotationDesignerException {
        return FormTools.importWidget(widget, form, null);
    }

    public static PDWidgetAnnotation importWidget(PDWidgetAnnotation widget, PDAcroForm form, String newName) throws AnnotationDesignerException {
        return FormTools.importWidget(widget, form, newName, new HashMap());
    }

    public static PDWidgetAnnotation importWidget(PDWidgetAnnotation widget, PDAcroForm form, String newName, boolean ignoreValue, boolean resetAppearance, Map copied) throws AnnotationDesignerException {
        PDAcroFormField field = widget.getAcroFormField();
        if (newName == null) {
            newName = field.getQualifiedName();
        }
        FormTools.checkNameConstraints(field, form, newName);
        COSDictionary copy = (COSDictionary)field.cosGetDict().copyDeep(copied);
        PDAcroFormField root = field.getLogicalRoot();
        if (root.cosGetDict() != field.cosGetDict()) {
            FormTools.fieldEntriesFill(root.cosGetDict(), copy, copied);
        }
        copy.remove(PDAnnotation.DK_P);
        copy.remove(PDAcroFormField.DK_T);
        if (ignoreValue) {
            copy.remove(PDAcroFormField.DK_V);
        }
        if (resetAppearance) {
            PDAppearanceTools.resetAppearance((COSDictionary)copy.get(PDAnnotation.DK_AP).asDictionary());
        }
        PDAcroFormField copyField = (PDAcroFormField)PDAcroFormField.META.createFromCos((COSObject)copy);
        FormTools.addField(copyField, newName, form, copied);
        if (field.getAcroForm() != null && field.getAcroForm() != form) {
            COSObject cosFont = field.getDefaultAppearanceFont().cosGetObject().copyDeep(copied);
            PDFont font = (PDFont)PDFont.META.createFromCos(cosFont);
            copyField.setDefaultAppearanceFont(font);
        }
        return (PDWidgetAnnotation)PDAnnotation.META.createFromCos(copyField.cosGetObject());
    }

    public static PDWidgetAnnotation importWidget(PDWidgetAnnotation widget, PDAcroForm form, String newName, boolean ignoreValue, Map copied) throws AnnotationDesignerException {
        return FormTools.importWidget(widget, form, newName, ignoreValue, true, copied);
    }

    public static PDWidgetAnnotation importWidget(PDWidgetAnnotation widget, PDAcroForm form, String newName, Map copied) throws AnnotationDesignerException {
        return FormTools.importWidget(widget, form, newName, false, copied);
    }

    protected static boolean isFieldEntry(COSName name) {
        if (PDAcroFormField.DK_FT.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_T.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_TU.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_TM.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_Ff.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_V.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_DV.equals((Object)name)) {
            return true;
        }
        if (IAdditionalActionSupport.DK_AA.equals((Object)name)) {
            return true;
        }
        if (PDAFButtonField.DK_Opt.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormField.DK_MaxLen.equals((Object)name)) {
            return true;
        }
        if (PDAFChoiceField.DK_Opt.equals((Object)name)) {
            return true;
        }
        if (PDAFChoiceField.DK_TI.equals((Object)name)) {
            return true;
        }
        if (PDAFChoiceField.DK_I.equals((Object)name)) {
            return true;
        }
        if (PDAFSignatureField.DK_Lock.equals((Object)name)) {
            return true;
        }
        if (PDAFSignatureField.DK_SV.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormNode.DK_DR.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormNode.DK_Encoding.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormNode.DK_Font.equals((Object)name)) {
            return true;
        }
        if (PDAcroFormNode.DK_DA.equals((Object)name)) {
            return true;
        }
        return PDAcroFormNode.DK_Q.equals((Object)name);
    }

    public static void renameField(PDAcroFormField field, String newName) throws AnnotationDesignerException {
        FormTools.renameField(field, newName, new HashMap());
    }

    public static void renameField(PDAcroFormField field, String newName, Map copied) throws AnnotationDesignerException {
        PDAcroForm form = field.getAcroForm();
        if (field.getQualifiedName().equals(newName)) {
            return;
        }
        FormTools.checkNameConstraints(field, form, newName);
        PDAcroFormField root = field.getLogicalRoot();
        if (root.cosGetDict() == field.cosGetDict()) {
            field.dispose(true);
            field.cosRemoveField(PDAcroFormField.DK_T);
        } else {
            FormTools.fieldEntriesFill(root.cosGetDict(), field.cosGetDict(), copied);
            field.dispose(true);
            FormTools.cleanFieldHierarchy(root);
            field.cosRemoveField(PDAcroFormField.DK_T);
        }
        FormTools.calculationOrderRemove(form, field);
        FormTools.addField(field, newName, form, copied);
    }

    private FormTools() {
    }
}

