/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.form.model.TextBasedField;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class DateTimeField
extends TextBasedField {
    private String dateStyle;
    private String timeStyle;
    private String pattern;

    public DateTimeField(FieldType type, IArgs args) {
        super(type, args);
    }

    protected DateTimeFormatter createFormatter() {
        if (StringTools.isEmpty((String)this.getDateStyle()) || "short".equals(this.getDateStyle())) {
            if (StringTools.isEmpty((String)this.getTimeStyle()) || "none".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
            }
            if ("short".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT);
            }
            if ("long".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.LONG);
            }
        } else if ("none".equals(this.getDateStyle())) {
            if (StringTools.isEmpty((String)this.getTimeStyle()) || "none".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
            }
            if ("short".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            }
            if ("long".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG);
            }
        } else if ("long".equals(this.getDateStyle())) {
            if (StringTools.isEmpty((String)this.getTimeStyle()) || "none".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
            }
            if ("short".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.SHORT);
            }
            if ("long".equals(this.getTimeStyle())) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG);
            }
        }
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT);
    }

    @Override
    public String format(Object value) {
        if (value instanceof ZonedDateTime) {
            return this.createFormatter().format((ZonedDateTime)value);
        }
        return super.format(value);
    }

    public String getDateStyle() {
        return this.dateStyle;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    @Override
    public Object restore(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ZonedDateTime.parse((String)value);
        }
        throw new IllegalArgumentException("'" + value + "' is not a legal DateTime");
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }
}

