/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.ri.AbstractUnit;

public final class AnnotatedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private final Unit<?> actualUnit;
    private final String annotation;

    public AnnotatedUnit(Unit<?> actualUnit, String annotation) {
        this.actualUnit = actualUnit instanceof AnnotatedUnit ? ((AnnotatedUnit)actualUnit).actualUnit : actualUnit;
        this.annotation = annotation;
    }

    public Unit<?> getActualUnit() {
        return this.actualUnit;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getSymbol() {
        return this.actualUnit.getSymbol();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.actualUnit.getBaseUnits();
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return (AbstractUnit)this.actualUnit.getSystemUnit();
    }

    @Override
    public Dimension getDimension() {
        return this.actualUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        if (this.actualUnit instanceof AbstractUnit) {
            return ((AbstractUnit)this.actualUnit).getSystemConverter();
        }
        throw new ClassCastException("Unknown type " + this.actualUnit.getClass());
    }

    @Override
    public int hashCode() {
        return this.actualUnit.hashCode() + this.annotation.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof AnnotatedUnit)) {
            return false;
        }
        AnnotatedUnit thatUnit = (AnnotatedUnit)that;
        return this.actualUnit.equals(thatUnit.actualUnit) && this.annotation.equals(thatUnit.annotation);
    }
}

