/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnitsService;
import javax.measure.spi.UnitFormatService;
import tec.units.ri.quantity.DefaultQuantityFactory;
import tec.uom.lib.common.function.IntPrioritySupplier;

public class DefaultServiceProvider
extends ServiceProvider {
    private final Map<Class, List<Object>> servicesLoaded = new HashMap<Class, List<Object>>();
    private final Map<Class, QuantityFactory> QUANTITY_FACTORIES = new HashMap<Class, QuantityFactory>();
    private static final Comparator<Object> SERVICE_COMPARATOR = new ServiceCompare();

    public int getPriority() {
        return 10;
    }

    protected <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    protected <T> T getService(Class<T> serviceType) {
        List<T> servicesFound = this.getServices(serviceType);
        if (servicesFound.isEmpty()) {
            return null;
        }
        return servicesFound.get(0);
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            Collections.sort(services, SERVICE_COMPARATOR);
            List previousServices = this.servicesLoaded.put(serviceType, services);
            return DefaultServiceProvider.list(previousServices != null ? previousServices.iterator() : services.iterator());
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            Collections.sort(services, SERVICE_COMPARATOR);
            return services;
        }
    }

    int compareTo(ServiceProvider o) {
        return DefaultServiceProvider.compare(this.getPriority(), o.getPriority());
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static <T> ArrayList<T> list(Iterator<T> i) {
        ArrayList<T> l = new ArrayList<T>();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    public SystemOfUnitsService getSystemOfUnitsService() {
        return this.getService(SystemOfUnitsService.class);
    }

    public UnitFormatService getUnitFormatService() {
        return this.getService(UnitFormatService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> quantity) {
        if (quantity == null) {
            throw new NullPointerException();
        }
        if (!this.QUANTITY_FACTORIES.containsKey(quantity)) {
            Map<Class, QuantityFactory> map = this.QUANTITY_FACTORIES;
            synchronized (map) {
                this.QUANTITY_FACTORIES.put(quantity, DefaultQuantityFactory.getInstance(quantity));
            }
        }
        return this.QUANTITY_FACTORIES.get(quantity);
    }

    static final class ServiceCompare
    implements Comparator<Object> {
        ServiceCompare() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.FINER, "Comparing " + o1 + " and " + o2);
            int prio1 = 0;
            int prio2 = 0;
            if (o1 instanceof IntPrioritySupplier) {
                prio1 = ((IntPrioritySupplier)o1).getPriority();
            }
            if (o2 instanceof IntPrioritySupplier) {
                prio2 = ((IntPrioritySupplier)o2).getPriority();
            }
            if (prio1 < prio2) {
                return 1;
            }
            if (prio2 < prio1) {
                return -1;
            }
            return o2.getClass().getName().compareTo(o1.getClass().getName());
        }
    }
}

