/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal;

public abstract class MathUtil {
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double two = 2.0;
    private static final double tiny = 1.0E-300;
    private static final double huge = 1.0E300;
    private static final double two53 = 9.007199254740992E15;
    private static final double two54 = 1.8014398509481984E16;
    private static final double twom54 = 5.551115123125783E-17;
    private static final double P1 = 0.16666666666666602;
    private static final double P2 = -0.0027777777777015593;
    private static final double P3 = 6.613756321437934E-5;
    private static final double P4 = -1.6533902205465252E-6;
    private static final double P5 = 4.1381367970572385E-8;
    private static final double pi_o_4 = 0.7853981633974483;
    private static final double pi_o_2 = 1.5707963267948966;
    private static final double pi = Math.PI;
    private static final double pi_lo = 1.2246467991473532E-16;
    private static final long HI_MASK = -4294967296L;
    private static final long LO_MASK = 0xFFFFFFFFL;
    private static final int HI_SHIFT = 32;
    private static final double twom1000 = 9.332636185032189E-302;
    private static final double o_threshold = 709.782712893384;
    private static final double u_threshold = -745.1332191019411;
    private static final double invln2 = 1.4426950408889634;
    private static final double[] halF = new double[]{0.5, -0.5};
    private static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
    private static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
    private static final double ln2_hi = 0.6931471803691238;
    private static final double ln2_lo = 1.9082149292705877E-10;
    private static final double Lg1 = 0.6666666666666735;
    private static final double Lg2 = 0.3999999999940942;
    private static final double Lg3 = 0.2857142874366239;
    private static final double Lg4 = 0.22222198432149784;
    private static final double Lg5 = 0.1818357216161805;
    private static final double Lg6 = 0.15313837699209373;
    private static final double Lg7 = 0.14798198605116586;
    private static final double[] bp = new double[]{1.0, 1.5};
    private static final double[] dp_h = new double[]{0.0, 0.5849624872207642};
    private static final double[] dp_l = new double[]{0.0, 1.350039202129749E-8};
    private static final double L1 = 0.5999999999999946;
    private static final double L2 = 0.4285714285785502;
    private static final double L3 = 0.33333332981837743;
    private static final double L4 = 0.272728123808534;
    private static final double L5 = 0.23066074577556175;
    private static final double L6 = 0.20697501780033842;
    private static final double lg2 = 0.6931471805599453;
    private static final double lg2_h = 0.6931471824645996;
    private static final double lg2_l = -1.904654299957768E-9;
    private static final double ovt = 8.008566259537294E-17;
    private static final double cp = 0.9617966939259756;
    private static final double cp_h = 0.9617967009544373;
    private static final double cp_l = -7.028461650952758E-9;
    private static final double ivln2 = 1.4426950408889634;
    private static final double ivln2_h = (double)1.442695f;
    private static final double ivln2_l = 1.9259629911266175E-8;
    private static final double[] atanhi = new double[]{0.4636476090008061, 0.7853981633974483, 0.982793723247329, 1.5707963267948966};
    private static final double[] atanlo = new double[]{2.2698777452961687E-17, 3.061616997868383E-17, 1.3903311031230998E-17, 6.123233995736766E-17};
    private static final double[] aT = new double[]{0.3333333333333293, -0.19999999999876483, 0.14285714272503466, -0.11111110405462356, 0.09090887133436507, -0.0769187620504483, 0.06661073137387531, -0.058335701337905735, 0.049768779946159324, -0.036531572744216916, 0.016285820115365782};

    public static final double exp(double a) {
        return MathUtil.ieee754_exp(a);
    }

    public static final double log(double a) {
        return MathUtil.ieee754_log(a);
    }

    public static final double pow(double a, double b) {
        return MathUtil.ieee754_pow(a, b);
    }

    public static final double atan(double a) {
        return MathUtil.ieee754_atan(a);
    }

    public static final double atan2(double b, double a) {
        return MathUtil.ieee754_atan2(a, b);
    }

    private static final double ieee754_exp(double x) {
        double t;
        double hi = 0.0;
        double lo = 0.0;
        int k = 0;
        long xl = Double.doubleToLongBits(x);
        int hx = (int)(xl >>> 32);
        int xsb = hx >> 31 & 1;
        if ((hx &= Integer.MAX_VALUE) >= 1082535490) {
            if (hx >= 0x7FF00000) {
                int lx = (int)(xl & 0xFFFFFFFFL);
                if ((hx & 0xFFFFF | lx) != 0) {
                    return x + x;
                }
                return xsb == 0 ? x : 0.0;
            }
            if (x > 709.782712893384) {
                return Double.POSITIVE_INFINITY;
            }
            if (x < -745.1332191019411) {
                return 0.0;
            }
        }
        if (hx > 1071001154) {
            if (hx < 1072734898) {
                hi = x - ln2HI[xsb];
                lo = ln2LO[xsb];
                k = 1 - xsb - xsb;
            } else {
                k = (int)(1.4426950408889634 * x + halF[xsb]);
                t = k;
                hi = x - t * ln2HI[0];
                lo = t * ln2LO[0];
            }
            x = hi - lo;
        } else if (hx < 0x3E300000 && 1.0E300 + x > 1.0) {
            return 1.0 + x;
        }
        t = x * x;
        double c = x - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        if (k == 0) {
            return 1.0 - (x * c / (c - 2.0) - x);
        }
        double y = 1.0 - (lo - x * c / (2.0 - c) - hi);
        long yl = Double.doubleToLongBits(y);
        if (k >= -1021) {
            return Double.longBitsToDouble(yl += (long)k << 52);
        }
        return Double.longBitsToDouble(yl += (long)(k + 1000) << 52) * 9.332636185032189E-302;
    }

    private static final double ieee754_log(double x) {
        long xl = Double.doubleToLongBits(x);
        int hx = (int)(xl >> 32);
        int lx = (int)(xl & 0xFFFFFFFFL);
        int k = 0;
        if (hx < 0x100000) {
            if ((hx & Integer.MAX_VALUE | lx) == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (hx < 0) {
                return (x - x) / 0.0;
            }
            k -= 54;
            hx = (int)(Double.doubleToLongBits(x *= 1.8014398509481984E16) >>> 32);
        }
        if (hx >= 0x7FF00000) {
            return x + x;
        }
        k += (hx >> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        x = Double.longBitsToDouble((long)(hx | i ^ 0x3FF00000) << 32 | Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        k += i >> 20;
        double f = x - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                double dk = k;
                return dk * 0.6931471803691238 + dk * 1.9082149292705877E-10;
            }
            double R = f * f * (0.5 - 0.3333333333333333 * f);
            if (k == 0) {
                return f - R;
            }
            double dk = k;
            return dk * 0.6931471803691238 - (R - dk * 1.9082149292705877E-10 - f);
        }
        double s = f / (2.0 + f);
        double dk = k;
        double z = s * s;
        i = hx - 398458;
        double w = z * z;
        int j = 440401 - hx;
        double t1 = w * (0.3999999999940942 + w * (0.22222198432149784 + w * 0.15313837699209373));
        double t2 = z * (0.6666666666666735 + w * (0.2857142874366239 + w * (0.1818357216161805 + w * 0.14798198605116586)));
        double R = t2 + t1;
        if ((i |= j) > 0) {
            double hfsq = 0.5 * f * f;
            if (k == 0) {
                return f - (hfsq - s * (hfsq + R));
            }
            return dk * 0.6931471803691238 - (hfsq - (s * (hfsq + R) + dk * 1.9082149292705877E-10) - f);
        }
        if (k == 0) {
            return f - s * (f - R);
        }
        return dk * 0.6931471803691238 - (s * (f - R) - dk * 1.9082149292705877E-10 - f);
    }

    private static final double ieee754_pow(double x, double y) {
        double p_l;
        double p_h;
        double r;
        double t2;
        double t1;
        double v;
        double u;
        double w;
        double t;
        int j;
        int k;
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int lx = (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        int hy = (int)(Double.doubleToLongBits(y) >>> 32);
        int ly = (int)(Double.doubleToLongBits(y) & 0xFFFFFFFFL);
        int ix = hx & Integer.MAX_VALUE;
        int iy = hy & Integer.MAX_VALUE;
        if ((iy | ly) == 0) {
            return 1.0;
        }
        if (ix > 0x7FF00000 || ix == 0x7FF00000 && lx != 0 || iy > 0x7FF00000 || iy == 0x7FF00000 && ly != 0) {
            return x + y;
        }
        int yisint = 0;
        if (hx < 0) {
            if (iy >= 0x43400000) {
                yisint = 2;
            } else if (iy >= 0x3FF00000) {
                k = (iy >> 20) - 1023;
                if (k > 20) {
                    j = ly >> 52 - k;
                    if (j << 52 - k == ly) {
                        yisint = 2 - (j & 1);
                    }
                } else if (ly == 0 && (j = iy >> 20 - k) << 20 - k == iy) {
                    yisint = 2 - (j & 1);
                }
            }
        }
        if (ly == 0) {
            if (iy == 0x7FF00000) {
                if ((ix - 0x3FF00000 | lx) == 0) {
                    return y - y;
                }
                if (ix >= 0x3FF00000) {
                    return hy >= 0 ? y : 0.0;
                }
                return hy < 0 ? -y : 0.0;
            }
            if (iy == 0x3FF00000) {
                if (hy < 0) {
                    return 1.0 / x;
                }
                return x;
            }
            if (hy == 0x40000000) {
                return x * x;
            }
            if (hy == 1071644672 && hx >= 0) {
                return Math.sqrt(x);
            }
        }
        double ax = Math.abs(x);
        if (lx == 0 && (ix == 0x7FF00000 || ix == 0 || ix == 0x3FF00000)) {
            double z = ax;
            if (hy < 0) {
                z = 1.0 / z;
            }
            if (hx < 0) {
                if ((ix - 0x3FF00000 | yisint) == 0) {
                    z = (z - z) / (z - z);
                } else if (yisint == 1) {
                    z = -z;
                }
            }
            return z;
        }
        int n = (hx >>> 31) + 1;
        if ((n | yisint) == 0) {
            return (x - x) / (x - x);
        }
        double s = 1.0;
        if ((n | yisint - 1) == 0) {
            s = -1.0;
        }
        if (iy > 1105199104) {
            if (iy > 1139802112) {
                if (ix <= 0x3FEFFFFF) {
                    return hy < 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
                if (ix >= 0x3FF00000) {
                    return hy > 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
            }
            if (ix < 0x3FEFFFFF) {
                return hy < 0 ? s * 1.0E300 * 1.0E300 : s * 1.0E-300 * 1.0E-300;
            }
            if (ix > 0x3FF00000) {
                return hy > 0 ? s * 1.0E300 * 1.0E300 : s * 1.0E-300 * 1.0E-300;
            }
            t = x - 1.0;
            w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
            u = (double)1.442695f * t;
            v = t * 1.9259629911266175E-8 - w * 1.4426950408889634;
            t1 = u + v;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = v - (t1 - u);
        } else {
            double ss;
            n = 0;
            if (ix < 0x100000) {
                n -= 53;
                ix = (int)(Double.doubleToLongBits(ax *= 9.007199254740992E15) >>> 32);
            }
            n += (ix >> 20) - 1023;
            j = ix & 0xFFFFF;
            ix = j | 0x3FF00000;
            if (j <= 235662) {
                k = 0;
            } else if (j < 767610) {
                k = 1;
            } else {
                k = 0;
                ++n;
                ix -= 0x100000;
            }
            ax = Double.longBitsToDouble((long)ix << 32 | Double.doubleToLongBits(ax) & 0xFFFFFFFFL);
            u = ax - bp[k];
            v = 1.0 / (ax + bp[k]);
            double s_h = ss = u * v;
            s_h = Double.longBitsToDouble(Double.doubleToLongBits(s_h) & 0xFFFFFFFF00000000L);
            double t_h = 0.0;
            t_h = Double.longBitsToDouble((long)((ix >> 1 | 0x20000000) + 524288 + (k << 18)) << 32 | Double.doubleToLongBits(t_h) & 0xFFFFFFFFL);
            double t_l = ax - (t_h - bp[k]);
            double s_l = v * (u - s_h * t_h - s_h * t_l);
            double s2 = ss * ss;
            r = s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
            s2 = s_h * s_h;
            t_h = 3.0 + s2 + (r += s_l * (s_h + ss));
            t_h = Double.longBitsToDouble(Double.doubleToLongBits(t_h) & 0xFFFFFFFF00000000L);
            t_l = r - (t_h - 3.0 - s2);
            u = s_h * t_h;
            v = s_l * t_h + t_l * ss;
            p_h = u + v;
            p_h = Double.longBitsToDouble(Double.doubleToLongBits(p_h) & 0xFFFFFFFF00000000L);
            p_l = v - (p_h - u);
            double z_h = 0.9617967009544373 * p_h;
            double z_l = -7.028461650952758E-9 * p_h + p_l * 0.9617966939259756 + dp_l[k];
            t = n;
            t1 = z_h + z_l + dp_h[k] + t;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = z_l - (t1 - t - dp_h[k] - z_h);
        }
        double y1 = y;
        y1 = Double.longBitsToDouble(Double.doubleToLongBits(y1) & 0xFFFFFFFF00000000L);
        p_l = (y - y1) * t1 + y * t2;
        p_h = y1 * t1;
        double z = p_l + p_h;
        j = (int)(Double.doubleToLongBits(z) >>> 32);
        int i = (int)(Double.doubleToLongBits(z) & 0xFFFFFFFFL);
        if (j >= 0x40900000) {
            if ((j - 0x40900000 | i) != 0) {
                return s * 1.0E300 * 1.0E300;
            }
            if (p_l + 8.008566259537294E-17 > z - p_h) {
                return s * 1.0E300 * 1.0E300;
            }
        } else if ((j & Integer.MAX_VALUE) >= 1083231232) {
            if ((j - -1064252416 | i) != 0) {
                return s * 1.0E-300 * 1.0E-300;
            }
            if (p_l <= z - p_h) {
                return s * 1.0E-300 * 1.0E-300;
            }
        }
        i = j & Integer.MAX_VALUE;
        k = (i >> 20) - 1023;
        n = 0;
        if (i > 1071644672) {
            n = j + (0x100000 >> k + 1);
            k = ((n & Integer.MAX_VALUE) >> 20) - 1023;
            t = 0.0;
            t = Double.longBitsToDouble((long)(n & ~(1048575 >> k)) << 32 | Double.doubleToLongBits(t) & 0xFFFFFFFFL);
            n = (n & 0xFFFFF | 0x100000) >> 20 - k;
            if (j < 0) {
                n = -n;
            }
            p_h -= t;
        }
        t = p_l + p_h;
        t = Double.longBitsToDouble(Double.doubleToLongBits(t) & 0xFFFFFFFF00000000L);
        u = t * 0.6931471824645996;
        v = (p_l - (t - p_h)) * 0.6931471805599453 + t * -1.904654299957768E-9;
        z = u + v;
        w = v - (z - u);
        t = z * z;
        t1 = z - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        r = z * t1 / (t1 - 2.0) - (w + z * w);
        z = 1.0 - (r - z);
        j = (int)(Double.doubleToLongBits(z) >>> 32);
        z = (j += n << 20) >> 20 <= 0 ? MathUtil.scalbn(z, n) : Double.longBitsToDouble((long)j << 32 | Double.doubleToLongBits(z) & 0xFFFFFFFFL);
        return s * z;
    }

    private static final double ieee754_atan(double x) {
        int id;
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x44100000) {
            if (ix > 0x7FF00000 || ix == 0x7FF00000 && (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL) != 0) {
                return x + x;
            }
            if (hx > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (ix < 1071382528) {
            if (ix < 1042284544 && 1.0E300 + x > 1.0) {
                return x;
            }
            id = -1;
        } else {
            x = Math.abs(x);
            if (ix < 0x3FF30000) {
                if (ix < 1072037888) {
                    id = 0;
                    x = (2.0 * x - 1.0) / (2.0 + x);
                } else {
                    id = 1;
                    x = (x - 1.0) / (x + 1.0);
                }
            } else if (ix < 1073971200) {
                id = 2;
                x = (x - 1.5) / (1.0 + 1.5 * x);
            } else {
                id = 3;
                x = -1.0 / x;
            }
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (aT[0] + w * (aT[2] + w * (aT[4] + w * (aT[6] + w * (aT[8] + w * aT[10])))));
        double s2 = w * (aT[1] + w * (aT[3] + w * (aT[5] + w * (aT[7] + w * aT[9]))));
        if (id < 0) {
            return x - x * (s1 + s2);
        }
        z = atanhi[id] - (x * (s1 + s2) - atanlo[id] - x);
        return hx < 0 ? -z : z;
    }

    private static final double ieee754_atan2(double x, double y) {
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int lx = (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        int hy = (int)(Double.doubleToLongBits(y) >>> 32);
        int ly = (int)(Double.doubleToLongBits(y) & 0xFFFFFFFFL);
        int ix = hx & Integer.MAX_VALUE;
        int iy = hy & Integer.MAX_VALUE;
        if ((ix | (lx | -lx) >> 31) > 0x7FF00000 || (iy | (ly | -ly) >> 31) > 0x7FF00000) {
            return x + y;
        }
        if ((hx - 0x3FF00000 | lx) == 0) {
            return MathUtil.ieee754_atan(y);
        }
        int m = hy >> 31 & 1 | hx >> 30 & 2;
        if ((iy | ly) == 0) {
            switch (m) {
                case 0: 
                case 1: {
                    return y;
                }
                case 2: {
                    return Math.PI;
                }
                case 3: {
                    return -Math.PI;
                }
            }
        }
        if ((ix | lx) == 0) {
            return hy < 0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (ix == 0x7FF00000) {
            if (iy == 0x7FF00000) {
                switch (m) {
                    case 0: {
                        return 0.7853981633974483;
                    }
                    case 1: {
                        return -0.7853981633974483;
                    }
                    case 2: {
                        return 2.356194490192345;
                    }
                    case 3: {
                        return -2.356194490192345;
                    }
                }
            } else {
                switch (m) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        return -0.0;
                    }
                    case 2: {
                        return Math.PI;
                    }
                    case 3: {
                        return -Math.PI;
                    }
                }
            }
        }
        if (iy == 0x7FF00000) {
            return hy < 0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        int k = iy - ix >> 20;
        double z = k > 60 ? 1.5707963267948966 : (hx < 0 && k < -60 ? 0.0 : MathUtil.ieee754_atan(Math.abs(y / x)));
        switch (m) {
            case 0: {
                return z;
            }
            case 1: {
                z = Double.longBitsToDouble(Double.doubleToLongBits(z) ^ Integer.MIN_VALUE);
                return z;
            }
            case 2: {
                return Math.PI - (z - 1.2246467991473532E-16);
            }
        }
        return z - 1.2246467991473532E-16 - Math.PI;
    }

    public static final double scalbn(double x, int n) {
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int lx = (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        int k = (hx & 0x7FF00000) >> 20;
        if (k == 0) {
            if ((lx | hx & Integer.MAX_VALUE) == 0) {
                return x;
            }
            hx = (int)(Double.doubleToLongBits(x *= 1.8014398509481984E16) >>> 32);
            k = ((hx & 0x7FF00000) >> 20) - 54;
            if (n < -50000) {
                return 1.0E-300 * x;
            }
        }
        if (k == 2047) {
            return x + x;
        }
        if ((k += n) > 2046) {
            return 1.0E300 * MathUtil.copysign(1.0E300, x);
        }
        if (k > 0) {
            x = Double.longBitsToDouble((long)(hx & 0x800FFFFF | k << 20) << 32 | Double.doubleToLongBits(x) & 0xFFFFFFFFL);
            return x;
        }
        if (k <= -54) {
            if (n > 50000) {
                return 1.0E300 * MathUtil.copysign(1.0E300, x);
            }
            return 1.0E-300 * MathUtil.copysign(1.0E-300, x);
        }
        x = Double.longBitsToDouble((long)(hx & 0x800FFFFF | (k += 54) << 20) << 32 | Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        return x * 5.551115123125783E-17;
    }

    public static final double copysign(double x, double y) {
        return Double.longBitsToDouble(Double.doubleToLongBits(x) & Long.MAX_VALUE | Double.doubleToLongBits(y) & Long.MIN_VALUE);
    }

    public static double negateExact(double a) {
        if (a == Double.MAX_VALUE || a == Double.MIN_VALUE) {
            throw new ArithmeticException("double overflow");
        }
        return -a;
    }

    public static double gcd(double a, double b) {
        if (b == 0.0) {
            return a;
        }
        return MathUtil.gcd(b, a % b);
    }
}

