/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.bytes.RandomByteProvider;
import de.intarsys.tools.crypto.bytes.StaticByteProvider;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessFilter;
import de.intarsys.tools.randomaccess.RandomAccessOutputStream;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class CBCEncryptedRandomAccess
extends RandomAccessFilter {
    private static final IByteStreamProvider BYTE_PROVIDER = new RandomByteProvider();
    private final ICipherFactory cipherFactory;
    private final IByteProvider keyProvider;
    private long localOffset;
    private long totalLength;
    private final byte[] ivBytes;
    private final int blockSize;
    private byte[] encryptedBuffer;
    private Cipher encipher;
    private OutputStream outputStream;
    private OutputStream cipherOutputStream;
    private long localWritePosition;

    public CBCEncryptedRandomAccess(IRandomAccess random, ICipherFactory cipherFactory) throws IOException {
        this(random, cipherFactory, new StaticByteProvider(BYTE_PROVIDER.getBytes(cipherFactory.getKeySize())));
    }

    public CBCEncryptedRandomAccess(IRandomAccess random, ICipherFactory cipherFactory, IByteProvider keyProvider) throws IOException {
        super(random);
        this.cipherFactory = cipherFactory;
        this.keyProvider = keyProvider;
        this.blockSize = cipherFactory.getBlockSize();
        this.ivBytes = new byte[this.blockSize];
        this.encryptedBuffer = new byte[4096];
        this.computeTotalLength();
    }

    public void close() throws IOException {
        this.writeFinalize();
        super.close();
    }

    protected void computeTotalLength() throws IOException {
        long encryptedLength = this.randomAccess.getLength();
        if (encryptedLength == 0L) {
            this.totalLength = 0L;
            return;
        }
        int lastBytesOffset = (int)(encryptedLength - (long)(2 * this.blockSize));
        lastBytesOffset = lastBytesOffset < 0 ? 0 : lastBytesOffset;
        this.seek(lastBytesOffset);
        byte[] buffer = new byte[2 * this.blockSize];
        int count = this.read(buffer, 0, buffer.length);
        this.totalLength = count >= 0 ? (long)(lastBytesOffset + count) : (long)lastBytesOffset;
        this.seek(0L);
    }

    protected ICipherParameter createCipherParameter(byte[] iv) throws IOException {
        return new SecretKeyParameter(iv, this.keyProvider.getBytes());
    }

    protected Cipher createDecipher(ICipherParameter cipherParameter) throws IOException, GeneralSecurityException {
        return this.getCipherFactory().createDecipher(cipherParameter);
    }

    protected Cipher createEncipher(ICipherParameter cipherParameter) throws IOException, GeneralSecurityException {
        return this.getCipherFactory().createEncipher(cipherParameter);
    }

    public ICipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    public long getLength() throws IOException {
        return this.totalLength;
    }

    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        int offsetModulo = (int)(this.localOffset % (long)this.blockSize);
        this.readIv();
        try {
            Cipher cipher = this.createDecipher(this.createCipherParameter(this.ivBytes));
            int readCount = Math.min(numBytes, numBytes);
            int size = Math.max(this.blockSize, readCount - readCount % this.blockSize) + 3 * this.blockSize;
            if (this.encryptedBuffer == null || size > this.encryptedBuffer.length) {
                this.encryptedBuffer = new byte[size];
            }
            int encryptedLength = StreamTools.read((IRandomAccess)this.randomAccess, (byte[])this.encryptedBuffer, (int)0, (int)size);
            ByteArrayInputStream bis = new ByteArrayInputStream(this.encryptedBuffer, 0, encryptedLength);
            CipherInputStream cis = new CipherInputStream(bis, cipher);
            for (int i = 0; i < offsetModulo; ++i) {
                ((InputStream)cis).read();
            }
            int count = StreamTools.read((InputStream)cis, (byte[])buffer, (int)start, (int)readCount);
            this.localOffset += (long)count;
            return count;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected void readIv() throws IOException {
        int offsetModulo = (int)(this.localOffset % (long)this.blockSize);
        int realOffset = (int)(this.localOffset - (long)offsetModulo - (long)this.blockSize);
        if (realOffset < 0) {
            this.randomAccess.seek(0L);
            Arrays.fill(this.ivBytes, (byte)0);
        } else {
            this.randomAccess.seek((long)realOffset);
            StreamTools.read((IRandomAccess)this.randomAccess, (byte[])this.ivBytes, (int)0, (int)this.ivBytes.length);
        }
    }

    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("negative offset");
        }
        this.localOffset = offset;
    }

    public void seekBy(long delta) throws IOException {
        this.localOffset += delta;
    }

    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        try {
            int offsetModulo = (int)(this.localOffset % (long)this.blockSize);
            if (this.localOffset != this.localWritePosition) {
                this.writeFinalize();
            }
            if (this.encipher == null) {
                this.readIv();
                this.encipher = this.createEncipher(this.createCipherParameter(this.ivBytes));
                this.outputStream = new RandomAccessOutputStream(this.randomAccess, this.localOffset - (long)offsetModulo);
                this.cipherOutputStream = new CipherOutputStream(this.outputStream, this.encipher);
            }
            this.cipherOutputStream.write(buffer, start, numBytes);
            this.localOffset += (long)numBytes;
            this.localWritePosition = this.localOffset;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected void writeFinalize() throws IOException {
        this.cipherOutputStream.close();
        this.outputStream.close();
        this.cipherOutputStream = null;
        this.outputStream = null;
        this.encipher = null;
    }
}

