/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.kdf;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class WithPrefixKeyDerivationFunction
implements IKeyDerivationFunction {
    private IKeyDerivationFunction kdf;
    private IByteProvider prefixProvider;

    @Override
    public byte[] derive(byte[] input, int length) throws GeneralSecurityException {
        try {
            byte[] tmpInput = ByteArrayTools.concat((byte[][])new byte[][]{this.getPrefixProvider().getBytes(), {45}, input});
            return this.getKdf().derive(tmpInput, length);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public IKeyDerivationFunction getKdf() {
        return this.kdf;
    }

    public IByteProvider getPrefixProvider() {
        return this.prefixProvider;
    }

    @PostConstruct
    public void init() {
        if (this.kdf == null) {
            throw new IllegalArgumentException("kdf is required for key derivation");
        }
        if (this.prefixProvider == null) {
            throw new IllegalArgumentException("prefixProvider is required for key derivation");
        }
    }

    public void setKdf(IKeyDerivationFunction keyDerivationFunction) {
        this.kdf = keyDerivationFunction;
    }

    public void setPrefixProvider(IByteProvider byteProvider) {
        this.prefixProvider = byteProvider;
    }
}

