/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.ocsp;

import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.tools.string.StringTools;

public class OCSPCacheKey {
    private IX509CertificateReference certificate;
    private IX509CertificateReference issuerCertificate;
    private String url;

    public boolean equals(Object obj) {
        if (!(obj instanceof OCSPCacheKey)) {
            return false;
        }
        OCSPCacheKey other = (OCSPCacheKey)obj;
        if (this.getCertificate() == null ? other.getCertificate() != null : !this.getCertificate().equals(other.getCertificate())) {
            return false;
        }
        if (this.getIssuerCertificate() == null ? other.getIssuerCertificate() != null : !this.getIssuerCertificate().equals(other.getIssuerCertificate())) {
            return false;
        }
        return !(this.getUrl() == null ? other.getUrl() != null : !this.getUrl().equals(other.getUrl()));
    }

    public IX509CertificateReference getCertificate() {
        return this.certificate;
    }

    public IX509CertificateReference getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        if (this.getCertificate() != null) {
            sb.append(this.getCertificate().hashCode());
        }
        sb.append("/");
        if (this.getIssuerCertificate() != null) {
            sb.append(this.getIssuerCertificate().hashCode());
        }
        sb.append("/");
        if (this.getUrl() != null) {
            sb.append(this.getUrl().hashCode());
        }
        return sb.toString().hashCode();
    }

    public void setCertificate(IX509CertificateReference certificate) {
        this.certificate = certificate;
    }

    public void setIssuerCertificate(IX509CertificateReference issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate: ").append(this.getCertificate()).append(StringTools.LS);
        sb.append("Issuer Certificate: ").append(this.getIssuerCertificate()).append(StringTools.LS);
        sb.append("URL: ").append(this.getUrl()).append(StringTools.LS);
        return sb.toString();
    }
}

