/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.commonpki;

import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Sequence;

public class CommonPKICertificatePathValidatorTools {
    public static boolean checkExcludedDirName(Set excluded, ASN1Sequence dns) {
        if (excluded.isEmpty()) {
            return true;
        }
        for (ASN1Sequence subtree : excluded) {
            if (!CommonPKICertificatePathValidatorTools.withinDNSubtree(dns, subtree)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkExcludedDNS(Set excluded, String dns) {
        if (excluded.isEmpty()) {
            return true;
        }
        for (String excludedElement : excluded) {
            if (!dns.endsWith(excludedElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkExcludedEmail(Set excluded, String email) {
        String dns = email.substring(email.indexOf(64) + 1);
        return CommonPKICertificatePathValidatorTools.checkExcludedDNS(excluded, dns);
    }

    public static boolean checkExcludedIP(Set excluded, byte[] ip) {
        if (excluded.isEmpty()) {
            return true;
        }
        String ipString = CommonPKICertificatePathValidatorTools.getIPString(ip);
        for (String excludedElement : excluded) {
            if (!ipString.startsWith(excludedElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkExcludedURI(Set excluded, String uri) {
        if (excluded.isEmpty()) {
            return true;
        }
        int qmIndex = uri.indexOf(63);
        if (qmIndex > -1) {
            uri = uri.substring(0, qmIndex);
        }
        for (String excludedElement : excluded) {
            if (!uri.startsWith(excludedElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPermittedDirName(Set permitted, ASN1Sequence dns) {
        if (permitted.isEmpty()) {
            return true;
        }
        for (ASN1Sequence subtree : permitted) {
            if (!CommonPKICertificatePathValidatorTools.withinDNSubtree(dns, subtree)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPermittedDNS(Set permitted, String dns) {
        if (permitted.isEmpty()) {
            return true;
        }
        for (String permittedElement : permitted) {
            if (!dns.endsWith(permittedElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPermittedEmail(Set permitted, String email) {
        String dns = email.substring(email.indexOf(64) + 1);
        return CommonPKICertificatePathValidatorTools.checkPermittedDNS(permitted, dns);
    }

    public static boolean checkPermittedIP(Set permitted, byte[] ip) {
        if (permitted.isEmpty()) {
            return true;
        }
        String ipString = CommonPKICertificatePathValidatorTools.getIPString(ip);
        for (String permittedElement : permitted) {
            if (!ipString.startsWith(permittedElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPermittedURI(Set permitted, String uri) {
        if (permitted.isEmpty()) {
            return true;
        }
        int qmIndex = uri.indexOf(63);
        if (qmIndex > -1) {
            uri = uri.substring(0, qmIndex);
        }
        for (String permittedElement : permitted) {
            if (!uri.startsWith(permittedElement)) continue;
            return true;
        }
        return false;
    }

    protected static String getIPString(byte[] octets) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < octets.length; ++i) {
            sb.append(octets[i] & 0xFF);
            if (i >= octets.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static Set intersectDirName(Set permitted, ASN1Sequence dn) {
        if (permitted.isEmpty()) {
            permitted.add(dn);
            return permitted;
        }
        HashSet<ASN1Sequence> intersect = new HashSet<ASN1Sequence>();
        for (ASN1Sequence subtree : permitted) {
            if (CommonPKICertificatePathValidatorTools.withinDNSubtree(dn, subtree)) {
                intersect.add(dn);
                continue;
            }
            if (!CommonPKICertificatePathValidatorTools.withinDNSubtree(subtree, dn)) continue;
            intersect.add(subtree);
        }
        return intersect;
    }

    public static Set intersectDNS(Set permitted, String dns) {
        if (permitted.isEmpty()) {
            permitted.add(dns);
            return permitted;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String permittedElement : permitted) {
            if (dns.endsWith(permittedElement)) {
                intersect.add(dns);
                continue;
            }
            if (!permittedElement.endsWith(dns)) continue;
            intersect.add(permittedElement);
        }
        return intersect;
    }

    public static Set intersectEmail(Set permitted, String email) {
        String dns = email.substring(email.indexOf(64) + 1);
        return CommonPKICertificatePathValidatorTools.intersectDNS(permitted, dns);
    }

    public static Set intersectIP(Set permitted, byte[] ip) {
        String ipString = CommonPKICertificatePathValidatorTools.getIPString(ip);
        if (permitted.isEmpty()) {
            permitted.add(ipString);
            return permitted;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String permittedElement : permitted) {
            if (ipString.startsWith(permittedElement)) {
                intersect.add(ipString);
                continue;
            }
            if (!permittedElement.startsWith(ipString)) continue;
            intersect.add(permittedElement);
        }
        return intersect;
    }

    public static Set intersectURI(Set permitted, String uri) {
        int qmIndex = uri.indexOf(63);
        if (qmIndex > -1) {
            uri = uri.substring(0, qmIndex);
        }
        if (permitted.isEmpty()) {
            permitted.add(uri);
            return permitted;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String permittedElement : permitted) {
            if (uri.startsWith(permittedElement)) {
                intersect.add(uri);
                continue;
            }
            if (!permittedElement.startsWith(uri)) continue;
            intersect.add(permittedElement);
        }
        return intersect;
    }

    public static Set unionDirName(Set excluded, ASN1Sequence dn) {
        if (excluded.isEmpty()) {
            excluded.add(dn);
            return excluded;
        }
        HashSet<ASN1Sequence> intersect = new HashSet<ASN1Sequence>();
        for (ASN1Sequence subtree : excluded) {
            if (CommonPKICertificatePathValidatorTools.withinDNSubtree(dn, subtree)) {
                intersect.add(subtree);
                continue;
            }
            if (CommonPKICertificatePathValidatorTools.withinDNSubtree(subtree, dn)) {
                intersect.add(dn);
                continue;
            }
            intersect.add(subtree);
            intersect.add(dn);
        }
        return intersect;
    }

    public static Set unionDNS(Set excluded, String dns) {
        if (excluded.isEmpty()) {
            excluded.add(dns);
            return excluded;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String excludedElement : excluded) {
            if (dns.endsWith(excludedElement)) {
                intersect.add(excludedElement);
                continue;
            }
            if (excludedElement.endsWith(dns)) {
                intersect.add(dns);
                continue;
            }
            intersect.add(excludedElement);
            intersect.add(dns);
        }
        return intersect;
    }

    public static Set unionEmail(Set excluded, String email) {
        String dns = email.substring(email.indexOf(64) + 1);
        return CommonPKICertificatePathValidatorTools.unionDNS(excluded, dns);
    }

    public static Set unionIP(Set excluded, byte[] ip) {
        String ipString = CommonPKICertificatePathValidatorTools.getIPString(ip);
        if (excluded.isEmpty()) {
            excluded.add(ipString);
            return excluded;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String excludedElement : excluded) {
            if (ipString.startsWith(excludedElement)) {
                intersect.add(excludedElement);
                continue;
            }
            if (excludedElement.startsWith(ipString)) {
                intersect.add(ipString);
                continue;
            }
            intersect.add(excludedElement);
            intersect.add(ipString);
        }
        return intersect;
    }

    public static Set unionURI(Set excluded, String uri) {
        int qmIndex = uri.indexOf(63);
        if (qmIndex > -1) {
            uri = uri.substring(0, qmIndex);
        }
        if (excluded.isEmpty()) {
            excluded.add(uri);
            return excluded;
        }
        HashSet<String> intersect = new HashSet<String>();
        for (String excludedElement : excluded) {
            if (uri.startsWith(excludedElement)) {
                intersect.add(excludedElement);
                continue;
            }
            if (excludedElement.startsWith(uri)) {
                intersect.add(uri);
                continue;
            }
            intersect.add(excludedElement);
            intersect.add(uri);
        }
        return intersect;
    }

    protected static boolean withinDNSubtree(ASN1Sequence dns, ASN1Sequence subtree) {
        if (subtree.size() < 1) {
            return false;
        }
        if (subtree.size() > dns.size()) {
            return false;
        }
        for (int i = subtree.size() - 1; i >= 0; --i) {
            if (subtree.getObjectAt(i).equals(dns.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }
}

