/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.validation.IVSRevocation;
import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.List;

public abstract class VSRevocation<R extends IVSRevocationRequest>
extends CommonValidationState
implements IVSRevocation {
    private final List<R> requestStates = new ArrayList<R>(3);

    protected VSRevocation(IValidationTarget target) {
        super(target);
    }

    protected VSRevocation(IValidationTarget target, int state) {
        super(target, state);
    }

    public void addRequestState(R requestState) {
        this.requestStates.add(requestState);
        this.increaseState((IValidationState)requestState);
    }

    protected boolean basicIsRecoverable() {
        return true;
    }

    @Override
    public List<R> getRequestStates() {
        return this.requestStates;
    }

    @Override
    public R getSuccessfulRequestState() {
        for (IVSRevocationRequest requestState : this.getRequestStates()) {
            if (requestState.getSeverity() != 0) continue;
            return (R)requestState;
        }
        return null;
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        return this.getSuccessfulRequestState() == null;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        if (!this.requestStates.isEmpty()) {
            printer.appendMember("requestStates", this.getRequestStates(), null);
        }
    }
}

