/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.VSRevocationRequest;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.Date;

public class VSOCSPRequest
extends VSRevocationRequest
implements IVSOCSPRequest {
    private String result;
    private boolean positiveStatement;
    private Date archiveCutoff;

    public VSOCSPRequest() {
        super((IValidationTarget)null);
    }

    public VSOCSPRequest(int state) {
        super(null, state);
    }

    public VSOCSPRequest(IOCSPResponse target) {
        super(new DefaultValidationTarget(target));
    }

    public VSOCSPRequest(IOCSPResponse target, int state) {
        super((IValidationTarget)new DefaultValidationTarget(target), state);
    }

    @Override
    protected boolean basicIsRecoverable() {
        return this.getResponse() == null;
    }

    @Override
    public Date getArchiveCutoff() {
        return this.archiveCutoff;
    }

    @Override
    public IOCSPResponse getResponse() {
        if (this.getValidationTarget() == null) {
            return null;
        }
        return (IOCSPResponse)this.getValidationTarget().getImpl();
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public String getUrl() {
        return this.getOrigin().getLabel();
    }

    @Override
    public boolean hasPositiveStatement() {
        return this.positiveStatement;
    }

    public void setArchiveCutoff(Date achiveCutoff) {
        this.archiveCutoff = achiveCutoff;
    }

    public void setPositiveStatement(boolean positiveStatement) {
        this.positiveStatement = positiveStatement;
    }

    public void setResponse(IOCSPResponse response) {
        this.setValidationTarget(new DefaultValidationTarget(response));
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("archiveCutoff", (Object)this.getArchiveCutoff(), null);
        printer.appendMember("positiveStatement", (Object)this.hasPositiveStatement(), null);
        printer.appendMember("result", (Object)this.getResult(), null);
    }
}

